//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndScopedLock.h
 * @brief		XR[vtbNNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndScopedLock_H_
#define INCG_IRIS_FndScopedLock_H_

//======================================================================
// include
#include "../../iris_object.h"

namespace iris {
namespace fnd
{

//======================================================================
// class
/**
 * @brief	XR[vtbNNX
 * @tparam	_Object	= bNNX^
*/
template<typename _Object>
class CScopedLock : public INonCopyable<>
{
public:
	typedef _Object		value_type;
	typedef _Object		*value_ptr;
	typedef _Object		&value_ref;
private:
	value_ref	m_object;	//!< ~[ebNX
	bool		m_lock;		//!< lock
public:
	/// RXgN^
	CScopedLock(value_ref object)
		: m_object(object), m_lock(false)
	{
		lock();
	}
	/// fXgN^
	~CScopedLock(void)
	{
		unlock();
	}
public:
	/// bN
	void	lock(void)
	{
		if( !m_lock )
		{
			m_object.Lock();
			m_lock = true;
		}
	}
	/// bN
	void	unlock(void)
	{
		if( m_lock )
		{
			m_object.Unlock();
			m_lock = false;
		}
	}
	/**
	 * @brief	bNĂ邩ǂ
	 * @return	^Ul
	*/
	bool	is_lock(void) const { return m_lock; }

public:
	value_ref	get(void)	{ return m_object; }

public:
	// ݊̂
	/// bN
	inline void	Lock(void)		{ lock(); }
	/// bN
	inline void	Unlock(void)	{ unlock(); }
};

}	// end of namespace fnd
}	// end of namespace iris

#endif
