//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndQueue.h
 * @brief		L[NXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndQueue_H_
#define INCG_IRIS_FndQueue_H_

//======================================================================
// include
#include "../../iris_object.h"
#include "../../iris_debug.h"

namespace iris {
namespace fnd
{

//======================================================================
// class
/**
 * @brief	L[NX
 * @tparam	_TN			= Ώی^
 * @tparam	MAX_SIZE	= őێ
*/
template< typename _TN, u32 MAX_SIZE=64 >
class CQueue : public INonCopyable< CQueue<_TN, MAX_SIZE> >
{
	typedef CQueue<_TN, MAX_SIZE>	_Myt;
public:
	typedef _TN			value_type;
	typedef _TN			*value_ptr;
	typedef _TN			&value_ref;
	typedef const _TN	*const_ptr;
	typedef const _TN	&const_ref;

protected:
	value_type	m_Queue[MAX_SIZE];	//!< L[
	u32			m_Cur;				//!< JgCfbNX
	u32			m_Req;				//!< vbVʒu
	u32			m_Size;				//!< L[ɂ鐔

public:
	/**
	 * @brief	RXgN^
	*/
	CQueue(void) : m_Cur(0), m_Req(0), m_Size(0) {}
	
	/**
	 * @brief	fXgN^
	*/
	~CQueue(void) {}

public:
	/**
	 * @brief	L[ɒǉ
	 * @param [in]	ref	= vf
	 * @return		
	*/
	bool		push(const_ref ref)
	{
		if( m_Size >= MAX_SIZE ) return false;
		m_Queue[m_Req++] = ref;
		if( m_Req == MAX_SIZE ) m_Req = 0;
		++m_Size;
		return true;
	}

	/**
	 * @brief	L[o
	 * @return	vf
	*/
	void		pop(void)
	{
		if( m_Size == 0 ) return;
		if( ++m_Cur == MAX_SIZE ) m_Cur = 0;
		--m_Size;
	}

public:
	/**
	 * @brief	L[ɓo^\Ȑ擾
	 * @return	o^\
	*/
	u32			capacity(void)	const	{ return MAX_SIZE; }

	/**
	 * @brief	L[ɓo^Ă鐔擾
	 * @return	o^
	*/
	u32			size(void)		const	{ return m_Size; }

	/**
	 * @brief	󂩂ǂ
	 * @return	^Ul
	*/
	bool		empty(void)		const	{ return (m_Size == 0); }

public:
	/**
	 * @brief	L[Q
	 * @param [in]	index	= L[̐擪̃CfbNX
	 * @return	L[̃|C^
	*/
	value_ref	get(u32 index)	
	{
		IRIS_ASSERT( index < m_Size );
		return m_Queue[(m_Cur+index)%MAX_SIZE]; 
	}

	/**
	 * @brief	L[Q
	 * @param [in]	index	= L[̐擪̃CfbNX
	 * @return	L[̃|C^
	*/
	value_ptr	ptr(u32 index)	
	{
		return index >= m_Size ? nullptr : &m_Queue[(m_Cur+index)%MAX_SIZE]; 
	}

};


}	// end of namespace wx
}	// end of namespace iris

#endif
