//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndObserver.h
 * @brief		Observerx[X
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndObserver_H_
#define INCG_IRIS_FndObserver_H_

//======================================================================
// include
#include "../../iris_object.h"

namespace iris {
namespace fnd
{

//======================================================================
// declare
template<class _Observer>class CSubject;
template<class _Observer>class CObserver;

//======================================================================
// class

//======================================================================
// observer
/**
 * @brief	ĎNX
 * @tparam	_Observer	= ĎNX
*/
template<class _Observer>
class CSubject : public INonCopyable<>
{
	typedef CSubject<_Observer>		_Myt;
	typedef CObserver<_Observer>	Observer;
public:
	typedef _Observer	value_type;
	typedef _Observer	&value_ref;	//!< ĎIuWFNgQƌ^
	typedef _Observer	*value_ptr;	//!< ĎIuWFNg|C^[
protected:
	value_ptr	m_pObservers;	//!< ĎIuWFNgXg
public:
	/// RXgN^
	CSubject(void) : m_pObservers(nullptr)	{}
public:
	/// fXgN^
	virtual ~CSubject(void)
	{
		Observer* curr = reinterpret_cast<Observer*>(m_pObservers);
		while(curr != nullptr)
		{
			curr->m_pSubject = nullptr;
			curr = reinterpret_cast<Observer*>(curr->m_pNext);
			curr->m_pNext = nullptr;
		}
		m_pObservers = nullptr;
	}
public:
	/// Observer̒ǉ
	virtual void	AttachObserver(value_ptr observer)
	{
		if( observer == nullptr ) return;
		Observer* obsrv = reinterpret_cast<Observer*>(observer);
		_Myt* old = obsrv->m_pSubject;
		if( old == this ) return;
		if( old != nullptr ) old->DetachObserver(obsrv);
		obsrv->m_pSubject = this;
		obsrv->m_pNext = m_pObservers;
		m_pObservers = observer;
	}

	/// Observeȓ}
	virtual bool	InsertObserver(value_ptr pos, value_ptr observer)
	{
		if( observer == nullptr ) return false;
		Observer* obsrv = reinterpret_cast<Observer*>(observer);
		_Myt* old = obsrv->m_pSubject;
		if( old == this ) return true;
		DetachObserver(obsrv);
		obsrv->m_pSubject = this;
		value_ptr curr = m_pObservers;
		Observer* prev = nullptr;
		while( curr != pos || curr != nullptr )
		{
			prev = reinterpret_cast<Observer*>(curr);
			curr = reinterpret_cast<Observer*>(curr)->m_pNext;
		}
		if( curr != pos ) return false;	// s
		if( prev == nullptr )
		{
			obsrv->m_pNext = m_pObservers;
			m_pObservers = observer;
		}
		else
		{
			prev->m_pNext = observer;
			obsrv->m_pNext = curr;
		}
		return true;
	}

	/// Observer̍폜
	virtual void	DetachObserver(Observer* observer)
	{
		if( observer == nullptr ) return;
		Observer* prev = nullptr;
		Observer* curr = reinterpret_cast<Observer*>(m_pObservers);
		while( curr != nullptr )
		{
			if( curr == observer )
			{
				if( prev != nullptr )
					prev->m_pNext = observer->m_pNext;
				else
					m_pObservers = observer->m_pNext;
				observer->m_pSubject = nullptr;
				observer->m_pNext = nullptr;
				return;
			}
			prev = curr;
			curr = reinterpret_cast<Observer*>(curr->m_pNext);
		}
	}

	/// ObserveȓS폜
	virtual void	DetachObserverAll(void)
	{
		while(m_pObservers != nullptr) { DetachObserver(reinterpret_cast<Observer*>(m_pObservers)); }
	}
public:
	value_ptr		GetObserver(void)	{ return m_pObservers; }	//!< Observer̎擾
	//! Observeř擾
	s32				GetObserverNum(void)	const
	{
		s32 cnt=0;
		value_ptr curr = m_pObservers; 
		while(curr != nullptr)
		{
			++cnt;
			curr = curr->GetNext();
		}
		return cnt;
	}
};

/**
 * @brief	ĎNX
 * @tparam	_Observer	= ĎNX(CRTP)
*/
template<class _Observer>
class CObserver : public INonCopyable<>
{
	friend	class CSubject<_Observer>;
	typedef CObserver<_Observer>	_Myt;
	typedef CSubject<_Observer>		_Subject;
protected:
	_Subject*	m_pSubject;	//!< ĎIuWFNg
	_Observer*	m_pNext;	//!< ̔ĎIuWFNg
public:
	/// RXgN^
	CObserver(void) : m_pSubject(nullptr), m_pNext(nullptr) {}
	/// fXgN^
	virtual ~CObserver(void)
	{
		if( m_pSubject != nullptr )	m_pSubject->DetachObserver(this);
	}

public:
	_Subject*			GetSubject(void)			{ return m_pSubject; }	//!< Subject̎擾
	const	_Subject*	GetSubject(void)	const	{ return m_pSubject; }	//!< Subject̎擾
	_Observer*			GetNext(void)				{ return m_pNext; }		//!< Observer̎擾
	const	_Observer*	GetNext(void)		const	{ return m_pNext; }		//!< Observer̎擾

public:
	/// Ď̉
	virtual void	release(void)
	{
		if( m_pSubject != nullptr )	m_pSubject->DetachObserver(this);
	}
};

}	// end of namespace fnd
}	// end of namespace iris

#endif
