//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndIterator.h
 * @brief		Ce[^ev[gt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndIterator_H_
#define INCG_IRIS_FndIterator_H_

//======================================================================
// include
#include "../../iris_object.h"

namespace iris {
namespace fnd
{

//======================================================================
// declare
template<class _Base, typename _TN, typename Ref, typename Ptr>class CIterator;

//======================================================================
// class
/**
 * @brief  Ce[^ev[gNX
 * @tparam	_Node	m[h^
*/
template<typename _Node>
class IIteratorBase : public IIrisObject
{
	typedef IIteratorBase<_Node>	_Myt;
protected:
	typedef	_Node		node_type;
	typedef	_Node*		node_ptr;
protected:
	node_ptr	m_pNode;	//!< m[h
public:
	// RXgN^
	IIteratorBase(void)	: m_pNode(nullptr) {}
	IIteratorBase(node_ptr node) : m_pNode(node) {}

protected:
	/// ̃m[hɐi߂
//	virtual void	inc(void) = 0;
	/// Õm[hɖ߂
//	virtual void	dec(void) = 0;
};

	/**
 * @brief  Ce[^ev[gNX
 * @tparam	_Base	Ce[^x[X
 * @tparam	_TN		f[^^
 * @tparam	Ref		Qƌ^
 * @tparam	Ptr		|C^^
*/
template<class _Base, typename _TN, typename Ref, typename Ptr>
class CIterator : public _Base
{
	typedef _Base							_Mybase;
	typedef	CIterator<_Base, _TN, Ref, Ptr>	_Myt;
//	using typename _Base::node_ptr;
	typedef	typename _Base::node_ptr	node_ptr;
public:
	typedef	CIterator<_Base, _TN, _TN&, _TN*>				iterator;
	typedef	CIterator<_Base, _TN, const _TN&, const _TN*>	const_iterator;
	typedef	CIterator<_Base, _TN, Ref, Ptr>					self;

	typedef	_TN							data_type;
	typedef	_TN*						ptr;
	typedef	_TN&						ref;
public:
	/// RXgN^
	CIterator(void){}
	CIterator(node_ptr np) : _Mybase(np) {}
	CIterator(const iterator& it) : _Mybase(it) {}
	
	/// Iy[^
	s32		operator == (const _TN& rhs)		const { return *static_cast<ptr>(this->m_pNode) == rhs; }
	s32		operator == (const node_ptr ptr)	const { return this->m_pNode == ptr; }
	s32		operator == (const _Myt& it)		const { return this->m_pNode == it.m_pNode; }
	s32		operator != (const _Myt& it)		const { return this->m_pNode != it.m_pNode; }
	ref		operator *	() const	{ return *(static_cast<ptr>(this->m_pNode)); }
	ptr		operator &	() const	{ return static_cast<ptr>(this->m_pNode); }
	ptr		operator -> () const	{ return static_cast<ptr>(this->m_pNode); }
	self&	operator ++ ()			{ this->inc(); return *this; }
	self	operator ++ (int)		{ self tmp = *this; this->inc(); return tmp; }
	self&	operator -- ()			{ this->dec(); return *this; }
	self	operator -- (int)		{ self tmp = *this; this->dec(); return tmp; }
	
	/// k
	static const _Myt null(void)	{ return static_cast<node_ptr>(nullptr); }
};


}	// end of namespace fnd
}	// end of namespace iris

#endif
