//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndBinarySearchTree.h
 * @brief		QT؃NXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndBinarySearchTree_H_
#define INCG_IRIS_FndBinarySearchTree_H_

//======================================================================
// include
#include "FndTemplateNode.h"
#include "FndIterator.h"

namespace iris {
namespace fnd
{

//======================================================================
// declare
class CBSTreeNodeBase;
template<typename _TN>class CBSTreeNode;
template<typename _TN, class _Liberator>class CBSTreeLiberateNode;
template<class _TC, class _NodeType>class IBSTree;
template<class _TC>class CBSTree;

//======================================================================
// class
/// 2T؃m[hx[XNX
template<class _NodeBase>
class IBSTreeNodeBase : public INonCopyable<_NodeBase>
{
public:
	typedef _NodeBase	node_type;	//!< m[h^Cv
	typedef _NodeBase	*node_ptr;	//!< m[h|C^
	typedef _NodeBase	&node_ref;	//!< m[hQƌ^

public:
	node_ptr	m_pLeft;	//!< ̃m[h
	node_ptr	m_pRight;	//!< Ẽm[h
	node_ptr	m_pParent;	//!< ẽm[h

public:
	/// RXgN^
	IBSTreeNodeBase(void)
		: m_pLeft(node_type::null_node())
		, m_pRight(node_type::null_node())
		, m_pParent(nullptr) {}

public:
	/// 폜̏
	virtual	void		erase(void)	= 0;
	/// N̉
	virtual void		unlink(void)
	{
		m_pParent = nullptr;
		m_pLeft = node_type::null_node();
		m_pRight = node_type::null_node();
	}
	/// NĂ邩ǂ
	bool				is_link(void)		const	{ return (m_pParent != nullptr || !_is_null_node(m_pLeft) || !_is_null_node(m_pRight)); }
	/// tm[hǂ
	bool				is_leaf(void)		const	{ return (m_pParent != nullptr || _is_null_node(m_pLeft) || _is_null_node(m_pRight)); }
	/// qm[h邩ǂ
	bool				is_has_child(void)	const	{ return !_is_null_node(m_pLeft) || !_is_null_node(m_pRight); }

public:
	/// null m[hǂ
	static bool			is_null_node(node_ptr node)		{ return (node == nullptr || node == node_type::null_node()); }
private:
	static bool			_is_null_node(node_ptr node)	{ return node_type::is_null_node(node); }
};
/// QT؃m[hx[XNX
class CBSTreeNodeBase : IBSTreeNodeBase<CBSTreeNodeBase>
{
public:
	/// 폜̏
	virtual	void		erase(void)	{}

public:
	/// nullptr m[h
	inline static node_ptr		null_node(void)			{ return nullptr; }
};

/**
 * @brief	QT؃m[hNXx[X
 * @tparam	_TN	= Ώی^
*/
template<typename _TN>
class CBSTreeNode : public CTemplateNode<_TN, CBSTreeNodeBase>
{
	typedef CTemplateNode<_TN, CBSTreeNodeBase> _Mybase;
public:
	IRIS_PP_USING_MYTYPENAME(value_ptr, _TN*, _Mybase);
public:
	/// RXgN^
	explicit CBSTreeNode(value_ptr ptr) : CTemplateNode<_TN, CBSTreeNodeBase>(ptr) {}
	/// RXgN^
	CBSTreeNode(void)	{}
};

/**
 * @brief	QT؃m[hNXx[X
 * @tparam	_TN			= Ώی^
 * @tparam	_Liberator	= NX^
*/
template< typename _TN, class _Liberator=CLiberatorObject<_TN> >
class CBSTreeLiberateNode : public CTemplateLiberateNode<_TN, CBSTreeNodeBase, _Liberator>
{
	typedef CTemplateLiberateNode<_TN, CBSTreeNodeBase, _Liberator>	_Mybase;
public:
	IRIS_PP_USING_MYTYPENAME(value_ptr, _TN*, _Mybase);
public:
	/// RXgN^
	explicit CBSTreeLiberateNode(value_ptr* ptr) : CTemplateLiberateNode<_TN, CBSTreeNodeBase, _Liberator>(ptr) {}
	/// RXgN^
	CBSTreeLiberateNode(void)	{}
};

/**
 * @brief	XgCe[^x[X
 * @tparam	_TC	= Ώی^
*/
template<class _TC>
class CBSTreeIteratorBase : public IIteratorBase<_TC>
{
	typedef IIteratorBase<_TC>			_Mybase;
	typedef CBSTreeIteratorBase<_TC>	_Myt;
protected:
	IRIS_PP_USING_MYTYPENAME(node_type	, _TC	, _Mybase);
	IRIS_PP_USING_MYTYPENAME(node_ptr	, _TC*	, _Mybase);
public:
	// RXgN^
	CBSTreeIteratorBase(void)	{}
	CBSTreeIteratorBase(node_ptr node) : _Mybase(node) {}
protected:
	/// ̃m[hɐi߂
	void	inc(void)
	{
		node_ptr node = this->m_pNode;
		IRIS_ASSERT( node != nullptr );
		// gEɂ΂
		if( !is_null_node(node->m_pRight) )
		{
			node = node->m_pRight;
			while(!is_null_node(node->m_pLeft)) { node = node->m_pLeft; }
		}
		else 
		{
			// eH
			node_ptr parent = nullptr;
			while(1)
			{
				parent = node->m_pParent;
				if( parent == nullptr )
				{
					node = nullptr;
					break;
				}
				if( parent->m_pLeft == node )
				{
					node = parent;
					break;
				}
				node = parent;
			}
		}
		this->m_pNode = node;
	}
	/// Õm[hɖ߂
	void	dec(void)
	{
		node_ptr node = this->m_pNode;
		IRIS_ASSERT( node != nullptr );
		// g荶ɂ΂
		if( !is_null_node(node->m_pLeft) )
		{
			node = node->m_pLeft;
			while(!is_null_node(node->m_pRight)) { node = node->m_pRight; }
		}
		else 
		{
			// eH
			node_ptr parent = nullptr;
			while(1)
			{
				parent = node->m_pParent;
				if( parent == nullptr || parent->m_pRight == node )
				{
					node = parent;
					break;
				}
				node = parent;
			}
		}
		this->m_pNode = node;
	}

protected:
	//! null m[hǂ
	bool	is_null_node(node_ptr node)
	{
		return (node == nullptr || node == node_type::null_node());
	}
};



/**
 * @brief	QT؃NXC^[tFCX
 * @tparam	_TC			= Ώی^
 * @tparam	_NodeType	= m[h^
*/
template< class _TC, class _NodeType >
class IBSTree : public IIrisObject
{
	typedef IBSTree<_TC, _NodeType>	_Myt;
public:
	typedef _TC				value_type;
	typedef _TC				*value_ptr;
	typedef _TC				&value_ref;
	typedef const value_type	*const_value_ptr;
	typedef const value_type	&const_value_ref;
	typedef	CIterator<CBSTreeIteratorBase<_NodeType>, _TC, _TC&, _TC*>				iterator;
	typedef	CIterator<CBSTreeIteratorBase<_NodeType>, _TC, const _TC&, const _TC*>	const_iterator;

protected:
	typedef _NodeType		node_type;
	typedef _NodeType		*node_ptr;
	typedef _NodeType		&node_ref;

protected:
	value_ptr				m_root;	//!< [gRei

public:
	/// RXgN^
	IBSTree(void) : m_root(static_cast<value_ptr>(null_node())) {}

	/**
	 * @brief	[gRei̎擾
	 * @return	[gRei
	*/
	value_ptr		root(void)					{ return m_root; }
	const value_ptr	root(void)		const		{ return m_root; }

	/**
	 * @brief	[gRei̎擾
	 * @return	[gReĩCe[^
	*/
	iterator		begin(void)					
	{
		node_ptr node = m_root;
		if( node != nullptr )
		{
			while(!is_null_node(node->m_pLeft)) { node = node->m_pLeft; }
		}
		return node;
	}
	const_iterator	begin(void)		const
	{ 
		node_ptr node = m_root;
		if( node != nullptr )
		{
			while(!is_null_node(node->m_pLeft)) { node = node->m_pLeft; }
		}
		return node;
	}

	/**
	 * @brief	I[Ce[^̎擾
	 * @note	iterator ŒHȂ̂Œ
	 * @return	I[Ce[^
	*/
	iterator		end(void)				{ return static_cast<node_ptr>(nullptr); }
	const_iterator	end(void)		const	{ return static_cast<node_ptr>(nullptr); }
	//iterator		end(void)				{ return null_node(); }
	//const_iterator	end(void)		const	{ return null_node(); }

	/**
	 * @brief	I[Ce[^̎擾
	 * @return	I[Ce[^
	*/
	iterator		back(void)
	{ 
		node_ptr node = m_root;
		while(!is_null_node(node->m_pRight)) { node = node->m_pRight; }
		return node;
	}
	const_iterator	back(void)		const
	{ 
		node_ptr node = m_root;
		while(!is_null_node(node->m_pRight)) { node = node->m_pRight; }
		return node;
	}

	/**
	 * @brief	m[h̒ǉ
	 * @param [in]	ptr	= ǉm[h
	 * @return	ǉ̃[gm[h
	*/
	value_ptr		add(value_ptr ptr)			{ return insert_internal(ptr); }

	/**
	 * @brief	m[h̒ǉ
	 * @param [in]	ptr	= ǉm[h
	 * @return	ǉ̃[gm[h
	*/
	value_ptr		insert(value_ptr ptr)		{ return insert_internal(ptr); }

	/**
	 * @brief	m[h̍폜
	 * @param [in]	pos	= 폜m[h
	 * @return	폜̃[gm[h
	*/
	value_ptr		erase(value_ptr pos)		{ return erase_internal(pos); }
	value_ptr		erase(iterator pos)			{ return erase_internal(&pos); }

	/**
	 * @brief	m[h̑S폜
	*/
	void			clear(void)					
	{
#if 0
		while(!is_null_node(m_root))
		{
			erase(m_root);
		}
#else
		for( iterator it=begin(); !is_null_node(&it); it=begin())
		{ 
			erase(it);
		}
#endif
	}

	/**
	 * @brief	m[ȟ
	 * @param [in]	key	= L[
	 * @return	L[Ɉvm[hBꍇnullptr
	*/
	iterator		search(const_value_ref key)	const	{ return search(m_root, key); }

	/**
	 * @brief	m[ȟ
	 * @param [in]	pos	= Ώۃ[g
	 * @param [in]	key	= L[
	 * @return	L[Ɉvm[hBꍇnullptr
	*/
	iterator		search(value_ptr pos, const_value_ref key)	const
	{
		if( is_null_node(pos) ) return iterator::null();

		if( !(*pos == key) ) 
		{
			if( key < *pos ) 
				return search(static_cast<value_ptr>(pos->m_pLeft), key);
			else
				return search(static_cast<value_ptr>(pos->m_pRight), key);
		}
		return pos;
	}

	/**
	 * @brief	m[ȟ
	 * @param [in]	key	= L[
	 * @return	L[Ɉvm[hBꍇnullptr
	*/
	template<typename _TT>
	iterator		search(_TT key)	const	{ return search(m_root, key); }

	/**
	 * @brief	m[ȟ
	 * @param [in]	pos	= Ώۃ[g
	 * @param [in]	key	= L[
	 * @return	L[Ɉvm[hBꍇnullptr
	*/
	template<typename _TT>
	iterator		search(value_ptr pos, _TT key)	const
	{
		if( is_null_node(pos) ) return iterator::null();

		if( !(*pos == key) ) 
		{
			if( *pos < key ) 
				return search(static_cast<value_ptr>(pos->m_pLeft), key);
			else
				return search(static_cast<value_ptr>(pos->m_pRight), key);
		}
		return pos;
	}

	/**
	 * @brief	m[ȟ(L[傫ŏ̃m[hԂ)
	 * @param [in]	key	= L[
	 * @return	L[Ɉvm[hBꍇ nullptr
	*/
	iterator		search_more(const_value_ref key)	const
	{
		if( this->m_root == nullptr ) return iterator::null();
		value_ptr node = m_root;
		value_ptr parent = nullptr;

		while( !is_null_node(node) )
		{
			if( *node == key) return node;
			parent = node;
			if( key < *node ) 
				node = static_cast<value_ptr>(node->m_pLeft);
			else
				node = static_cast<value_ptr>(node->m_pRight);
		}
		while(parent != nullptr) 
		{
			if(key < *parent) return parent;
			parent = static_cast<value_ptr>(parent->m_pParent);
		}
		if(key < *m_root) return m_root;
		return iterator::null();
	}

	/**
	 * @brief	m[ȟ(L[ő̃m[hԂ)
	 * @param [in]	key	= L[
	 * @return	L[Ɉvm[hBꍇnullptr
	*/
	iterator		search_less(const_value_ref key)	const
	{
		if( this->m_root == nullptr ) return iterator::null();
		value_ptr node = m_root;
		value_ptr parent = nullptr;

		while( !is_null_node(node) )
		{
			if( *node == key) return node;
			parent = node;
			if( key < *node ) 
				node = static_cast<value_ptr>(node->m_pLeft);
			else
				node = static_cast<value_ptr>(node->m_pRight);
		}
		while(parent != nullptr) 
		{
			if(*parent < key) return parent;
			parent = static_cast<value_ptr>(parent->m_pParent);
		}
		if(*m_root < key) return m_root;
		return iterator::null();
	}

	/**
	 * @brief	ׂẴm[hɏs
	 * @param [in]	fnuc	= ֐
	*/
	template<typename Func>
	void			foreach(Func func)	{ foreach(m_root, func); }

	/**
	 * @brief	ׂẴm[hɏs
	 * @param [in]	pos		= [gʒu
	 * @param [in]	fnuc	= ֐
	*/
	template<typename Func>
	void			foreach(value_ptr pos, Func func)
	{
		if( is_null_node(pos) ) return;
		foreach(pos->m_pLeft , func); 
		foreach(pos->m_pRight, func); 
		func( pos );
	}

	/**
	 * @brief	󂩂ǂ
	 * @return	^Ul
	*/
	bool			empty(void)		const		{ return is_null_node(m_root); }

	/**
	 * @brief	m[h̎擾
	*/
	s32				count(void)		const		{ return count(m_root); }

	/**
	 * @brief	m[h̍擾
	*/
	s32				height(void)	const		{ return height(m_root); }
protected:

	/**
	 * @brief	m[h̓ւ
	 * @param [in]	n1	= ւm[h
	 * @param [in]	n2	= ւm[h
	 * @return	ւ̃[gm[h
	*/
	virtual	value_ptr		swap(value_ptr n1, value_ptr n2)
	{
		IRIS_ASSERT( !is_null_node(n1) );
		IRIS_ASSERT( !is_null_node(n2) );
		if( n1 == n2 ) return m_root;
#ifdef _IRIS_DEBUGTEST_ENABLE
		s32 cnt1 = count(n1);
		s32 cnt2 = count(n2);
#endif
		value_ptr p1 = static_cast<value_ptr>(n1->m_pParent);
		value_ptr p2 = static_cast<value_ptr>(n2->m_pParent);
		if( p1 == n2 ) p1 = n1;
		else if( p2 == n1 ) p2 = n2;

		// ̃m[hւ
		value_ptr tmp = static_cast<value_ptr>(n1->m_pLeft);
		n1->m_pLeft = n2->m_pLeft;
		n2->m_pLeft = tmp;

		// Ẽm[hւ
		tmp = static_cast<value_ptr>(n1->m_pRight);
		n1->m_pRight = n2->m_pRight;
		n2->m_pRight = tmp;

		if( !is_null_node(n1->m_pLeft ) ) 
		{
			if(n1->m_pLeft == n1)	n1->m_pLeft = n2;
			n1->m_pLeft->m_pParent  = n1;
		}
		if( !is_null_node(n1->m_pRight) )
		{
			if(n1->m_pRight == n1)	n1->m_pRight = n2;
			n1->m_pRight->m_pParent = n1;
		}
		if( !is_null_node(n2->m_pLeft ) )
		{
			if(n2->m_pLeft == n2)	n2->m_pLeft = n1;
			n2->m_pLeft->m_pParent  = n2;
		}
		if( !is_null_node(n2->m_pRight) ) 
		{
			if(n2->m_pRight == n2)	n2->m_pRight = n1;
			n2->m_pRight->m_pParent = n2;
		}

		n1->m_pParent = p2;
		n2->m_pParent = p1;

		if( p1 == nullptr ) 
		{
			IRIS_ASSERT( p2 != nullptr );
			m_root = n2;
		}
		else
		{
			if( p1->m_pLeft == n1 ) p1->m_pLeft  = n2;
			else					p1->m_pRight = n2;
		}
		if( p2 == nullptr ) 
		{
			IRIS_ASSERT( p1 != nullptr );
			m_root = n1;
		}
		else
		{
			if( p2->m_pLeft == n2 ) p2->m_pLeft  = n1;
			else					p2->m_pRight = n1;
		}
#ifdef _IRIS_DEBUGTEST_ENABLE
		check_tree_root();
		IRIS_ASSERT( cnt1 == count(n2) );
		IRIS_ASSERT( cnt2 == count(n1) );
#endif
		return m_root;
	}

protected:
	/**
	 * @brief	EɂP]
	 * @param [in]	node	= ]̊_m[h
	 * @return	]̃[gm[h
	*/
	virtual value_ptr rotate_right1(value_ptr node)
	{
		value_ptr	p = node;
		value_ptr	l = static_cast<value_ptr>(p->m_pLeft);
		value_ptr	r = static_cast<value_ptr>(p->m_pParent);
		value_ptr	rp = r == nullptr ? nullptr : static_cast<value_ptr>(r->m_pParent);
		value_ptr	rl = static_cast<value_ptr>(p->m_pRight);
		IRIS_ASSERT( p == r->m_pLeft );

		p->m_pParent	= rp;
		p->m_pLeft		= l;
		p->m_pRight		= r;
		if( !is_null_node(l) )	l->m_pParent = p;
		if( !is_null_node(r) )
		{
			r->m_pParent	= p;
			r->m_pLeft		= rl;
		}

		if( !is_null_node(rl) )	rl->m_pParent = r;
		if(rp == nullptr)	m_root = p;
		else 
		{
			if(rp->m_pLeft == r)	rp->m_pLeft = p;
			else					rp->m_pRight = p;
		}
#ifdef _IRIS_DEBUGTEST_ENABLE
		IRIS_ASSERT( is_null_node(l) || l->m_pParent == p );
		IRIS_ASSERT( is_null_node(r) || r->m_pParent == p );
		IRIS_ASSERT( p->m_pLeft == l );
		IRIS_ASSERT( p->m_pRight == r );
#endif
		return m_root;
	}

	/**
	 * @brief	ɂP]
	 * @param [in]	node	= ]̊_m[h
	 * @return	]̃[gm[h
	*/
	virtual value_ptr rotate_left1(value_ptr node)
	{
		value_ptr	p = node;
		value_ptr	l = static_cast<value_ptr>(p->m_pParent);
		value_ptr	r = static_cast<value_ptr>(p->m_pRight);
		value_ptr	lp = l == nullptr ? nullptr : static_cast<value_ptr>(l->m_pParent);
		value_ptr	lr = static_cast<value_ptr>(p->m_pLeft);
		IRIS_ASSERT( l != nullptr );
		IRIS_ASSERT( r != nullptr );
		IRIS_ASSERT( p == l->m_pRight );

		p->m_pParent	= lp;
		p->m_pLeft		= l;
		if( !is_null_node(l) )
		{
			l->m_pParent	= p;
			l->m_pRight		= lr;
		}

		if( !is_null_node(lr) )	lr->m_pParent = l;
		if( lp == nullptr )	m_root = p;
		else 
		{
			if(lp->m_pLeft == l)	lp->m_pLeft = p;
			else					lp->m_pRight = p;
		}
#ifdef _IRIS_DEBUGTEST_ENABLE
		IRIS_ASSERT( is_null_node(l) || l->m_pParent == p );
		IRIS_ASSERT( is_null_node(r) || r->m_pParent == p );
		IRIS_ASSERT( p->m_pLeft == l );
		IRIS_ASSERT( p->m_pRight == r );
#endif
		return m_root;
	}

	/**
	 * @brief	EɂQ]
	 * @param [in]	node	= ]̊_m[h
	 * @return	]̃[gm[h
	*/
	virtual value_ptr rotate_right2(value_ptr node)
	{
		IRIS_ASSERT( node->m_pParent != nullptr );
		value_ptr p  = static_cast<value_ptr>(node->m_pParent);
		value_ptr pp = static_cast<value_ptr>(p->m_pParent);
		IRIS_ASSERT( p->m_pRight == node );
		IRIS_ASSERT( pp == nullptr || pp->m_pLeft == p );
		return rotate2(node, p, pp, pp);
	}

	/**
	 * @brief	ɂQ]
	 * @param [in]	node	= ]̊_m[h
	 * @return	]̃[gm[h
	*/
	virtual value_ptr rotate_left2(value_ptr node)
	{
		IRIS_ASSERT( node->m_pParent != nullptr );
		value_ptr p  = static_cast<value_ptr>(node->m_pParent);
		value_ptr pp = static_cast<value_ptr>(p->m_pParent);
		IRIS_ASSERT( p->m_pLeft == node );
		IRIS_ASSERT( pp == nullptr || pp->m_pRight == p );
		return rotate2(node, pp, p, pp);
	}

	/**
	 * @brief	Q]
	 * @param [in]	parent	= ]̐em[h
	 * @param [in]	left	= ]̐e̍m[h
	 * @param [in]	right	= ]̐ẻEm[h
	 * @param [in]	rotate	= ]̐ẻ]̃m[h
	 * @return	]̃[gm[h
	*/
	virtual value_ptr rotate2(value_ptr parent, value_ptr left, value_ptr right, value_ptr rotate) 
	{
		value_ptr	p = parent;
		value_ptr	l = left;
		value_ptr	r = right;
		node_ptr	lr = p->m_pLeft;
		node_ptr	rl = p->m_pRight;

		p->m_pParent	= rotate->m_pParent;
		p->m_pLeft		= l;
		p->m_pRight		= r;
		if( !is_null_node(l) )
		{
			l->m_pParent	= p;
			l->m_pRight		= lr;
			if( !is_null_node(lr) )	lr->m_pParent = l;
		}
		if( !is_null_node(r) )
		{
			r->m_pParent	= p;
			r->m_pLeft		= rl;
			if( !is_null_node(rl) )	rl->m_pParent = r;
		}
		if(p->m_pParent == nullptr) m_root = p;
		else 
		{
			if (p->m_pParent->m_pLeft == rotate)	p->m_pParent->m_pLeft = p;
			else									p->m_pParent->m_pRight = p;
		}
		return m_root;
	}

protected:
	/**
	 * @brief	m[h̒ǉ
	 * @param [in]	ptr	= ǉm[h
	 * @return	ǉ̃[gm[h
	*/
	virtual value_ptr		insert_internal(value_ptr ptr)
	{
		value_ptr	node = m_root;
		value_ptr	parent = nullptr;
		IRIS_ASSERT( !ptr->is_link() );
#ifdef _IRIS_DEBUGTEST_ENABLE
		s32 cnt = count();
#endif
		IRIS_ASSERT( ptr != nullptr );
		// [g̃|C^ nullptr ̏ꍇptr[gƂ
		if( is_null_node(m_root) ) 
		{
			ptr->m_pLeft	= null_node();
			ptr->m_pRight	= null_node();
			ptr->m_pParent	= nullptr;
			m_root = ptr;
#ifdef _IRIS_DEBUGTEST_ENABLE
		IRIS_ASSERT( cnt+1 == count() );
#endif
			return m_root;
		}

		// [gqm[hɉȂK؂ȈʒuT
		node_ptr tmp = node;
		do
		{
			node = static_cast<value_ptr>(tmp);
			// L[dꍇ̓m[h̒ǉ͍sȂ
			//if(*ptr == *node)	return m_root;
			parent = node;
			// ǉL[ݔrĂm[h̃L[菬΍֔ri߂
			if(*ptr < *node)	tmp = node->m_pLeft;
			// ǉL[ݔrĂm[h̃L[傫ΉE֔ri߂
			else				tmp = node->m_pRight;
		} while( !is_null_node(tmp) );

		ptr->m_pParent	= parent;
		ptr->m_pLeft	= ptr->m_pRight = null_node();

		// m[hɐeꍇim[h[gȊȌꍇj́AoX蒼
		if(parent != nullptr) 
		{
			if( *ptr < *parent )	parent->m_pLeft = ptr;
			else					parent->m_pRight = ptr;
			m_root = rotate_tree_add(parent, ptr);
		}
#ifdef _IRIS_DEBUGTEST_ENABLE
		check_tree_root();
		IRIS_ASSERT( (cnt+1) == count() );
#endif
		IRIS_ASSERT( ptr->is_link() );
		return m_root;
	}

	/**
	 * @brief	m[h̍폜
	 * @param [in]	pos	= 폜m[h
	 * @return	폜̃[gm[h
	*/
	virtual	value_ptr		erase_internal(value_ptr pos)
	{
		value_ptr	target;	// 폜^[Qbg
		value_ptr	last;	// ړm[ĥƂƂ̐em[h
		node_ptr	swapkey = nullptr;	// 폜m[hƌm[h
		IRIS_ASSERT( !is_null_node(pos) && m_root != nullptr );
		// nm[h͂TreeɂƂėLȃm[hłƑO
		target = last = pos;
#ifdef _IRIS_DEBUGTEST_ENABLE
		s32 cnt = count();
#endif

		// Ȃ
		if( is_null_node(target->m_pLeft) )
		{
			// EȂ
			if( is_null_node(target->m_pRight) )
			{
				last = static_cast<value_ptr>(target->m_pParent);
				if( !is_null_node(last) )
				{
					if( last->m_pLeft == target )	last->m_pLeft = null_node();
					else							last->m_pRight = null_node();
				}
				swapkey = null_node();
			}
			// E͂ꍇ
			else
			{
				swapkey = target->m_pRight;
				last = static_cast<value_ptr>(target->m_pParent);
				swapkey->m_pParent = last;
				if(last != nullptr)
				{
					// ؂藣
					if( last->m_pLeft == target )	last->m_pLeft = swapkey;
					else							last->m_pRight = swapkey;
				}
			}
		}
		else if( is_null_node(target->m_pRight) )
		{
			// EȂ
			swapkey = target->m_pLeft;
			last = static_cast<value_ptr>(target->m_pParent);
			swapkey->m_pParent = last;
			if(last != nullptr)
			{
				// ؂藣
				if( last->m_pLeft == target )	last->m_pLeft = swapkey;
				else							last->m_pRight = swapkey;
			}
		}
		else
		{
			// EƂɃm[h
			// ̏ꍇA폜m[hƈʒuύX͓̂̃m[h
			while(1)
			{
				value_ptr next = static_cast<value_ptr>(target->m_pRight);
				while( !is_null_node(next->m_pLeft) )
				{
					last = next;
					next = static_cast<value_ptr>(next->m_pLeft);
				}
				if( last != target )
				{
					s32 c1 = count(target);
					swap(target, next);
					last->m_pLeft = target->m_pRight;
					if( !is_null_node(last->m_pLeft) ) last->m_pLeft->m_pParent = last;
					swapkey = last->m_pLeft;
					break;
				}

				next = static_cast<value_ptr>(target->m_pLeft);
				while( !is_null_node(next->m_pRight) )
				{
					last = next;
					next = static_cast<value_ptr>(next->m_pRight);
				}
				if( last != target )
				{
					swap(target, next);
					last->m_pRight = target->m_pLeft;
					if( !is_null_node(last->m_pRight) ) last->m_pRight->m_pParent = last;
					swapkey = last->m_pRight;
					break;
				}

				// IɉE
				swap(target, static_cast<value_ptr>(target->m_pRight));
				swapkey = target->m_pRight;
				last = static_cast<value_ptr>(target->m_pParent);
				if( !is_null_node(swapkey) )
				{
					swapkey->m_pParent = last;
					swapkey->m_pLeft = target->m_pLeft;
					IRIS_ASSERT( is_null_node(swapkey->m_pLeft) );
				}
				if(last != nullptr)
				{
					// ؂藣
					if( last->m_pLeft == target )	last->m_pLeft = swapkey;
					else							last->m_pRight = swapkey;
				}
				break;
			}
		}

		if( last == nullptr ) m_root = static_cast<value_ptr>(swapkey);
#ifdef _IRIS_DEBUGTEST_ENABLE
		check_tree_struct(m_root);
		IRIS_ASSERT( (cnt-1) == count() );
#endif
		m_root = rotate_tree_sub(last, target, swapkey);
		target->unlink();
		target->erase();
#ifdef _IRIS_DEBUGTEST_ENABLE
		check_tree_root();
		IRIS_ASSERT( (cnt-1) == count() );
#endif
		return m_root;
	}

protected:
	/**
	 * @brief	c[]ăoX𐮂(m[h̒ǉ)
	 * @param [in]	node	= ǉsm[h̐e
	 * @param [in]	key		= ǉsm[h̃L[
	 * @return	]̃[gm[h
	*/
	virtual	value_ptr		rotate_tree_add(value_ptr node, value_ptr key)	= 0;

	/**
	 * @brief	c[]ăoX𐮂(m[h̍폜)
	 * @param [in]	node	= 폜sm[h̐e
	 * @param [in]	key		= 폜sm[h̃L[
	 * @param [in]	swapkey	= 폜ɌL[
	 * @return	]̃[gm[h
	*/
	virtual	value_ptr		rotate_tree_sub(value_ptr node, value_ptr key, node_ptr swapkey)	= 0;

	/**
	 * @brief	wm[hȉ̃m[h擾
	*/
	s32		count(node_ptr ptr)	const
	{
		if( is_null_node(ptr) ) return 0;
		s32 n = 1;
		n += count(ptr->m_pLeft);
		n += count(ptr->m_pRight);
		return n;
	}

	/**
	 * @brief	wm[hȉ̃m[h̍擾
	*/
	s32		height(node_ptr ptr) const
	{
		if( is_null_node(ptr) ) return 0;
		s32 l = height(ptr->m_pLeft);
		s32 r = height(ptr->m_pRight);
		return 1 + ((l > r) ? l : r);
	}
public:
	/// nullptrm[h
	static node_ptr			null_node(void)
	{
		return node_type::null_node();
	}
	/// nullptr or null_nodeǂ
	virtual bool			is_null_node(node_ptr ptr)	const	{ return (ptr == nullptr || ptr == null_node()); }


#ifdef _IRIS_DEBUGTEST_ENABLE
	/// m[h̐
	virtual void	check_node(value_ptr node) const
	{
		if( node == nullptr ) return;
		if( node->m_pParent != nullptr )
		{
			IRIS_ASSERT(node->m_pParent->m_pLeft == node || node->m_pParent->m_pRight == node);
		}

		IRIS_ASSERT( node != node->m_pLeft );
		IRIS_ASSERT( node != node->m_pRight );

		if( !is_null_node(node->m_pLeft) )	IRIS_ASSERT( node->m_pLeft->m_pParent  == node );
		if( !is_null_node(node->m_pRight) )	IRIS_ASSERT( node->m_pRight->m_pParent == node );
	}
	/// c[̐
	virtual void	check_tree(value_ptr node) const
	{
		if( is_null_node(node) ) return;
		check_node(node);
		check_tree(static_cast<value_ptr>(node->m_pLeft));
		check_tree(static_cast<value_ptr>(node->m_pRight));
	}
	/// c[̐
	virtual void	check_tree_root(void) const
	{
		check_tree(m_root);
	}

	/// c[̐؁ic[\̂݁j
	void	check_tree_struct(value_ptr node) const
	{
		if( is_null_node(node) ) return;
		_Myt::check_node(node);
		_Myt::check_tree_struct(static_cast<value_ptr>(node->m_pLeft));
		_Myt::check_tree_struct(static_cast<value_ptr>(node->m_pRight));
	}
#endif
};

/**
 * @brief	QT؃NXC^[tFCX
 * @tparam	_TC	= Ώی^
*/
template<class _TC>
class CBSTree : public IBSTree<_TC, CBSTreeNodeBase>
{
	typedef IBSTree<_TC, CBSTreeNodeBase>	_Base;
public:
	IRIS_PP_USING_MYTYPENAME(value_ptr	, _TC*				, _Base);
	IRIS_PP_USING_MYTYPENAME(node_ptr	, CBSTreeNodeBase*	, _Base);
	
public:
	/// RXgN^
	CBSTree(void)	{}

private:
	/**
	 * @brief	c[]ăoX𐮂(m[h̒ǉ)
	 * @param [in]	node	= ǉsm[h̐e
	 * @param [in]	key		= ǉsm[h̃L[
	 * @return	]̃[gm[h
	*/
	virtual	value_ptr		rotate_tree_add(value_ptr node, value_ptr key)
	{
		IRIS_UNUSED_VARIABLE(node);
		IRIS_UNUSED_VARIABLE(key);
		return this->m_root;
	}

	/**
	 * @brief	c[]ăoX𐮂(m[h̍폜)
	 * @param [in]	node	= 폜sm[h̐e
	 * @param [in]	key		= 폜sm[h̃L[
	 * @param [in]	swapkey	= 폜ɌL[
	 * @return	]̃[gm[h
	*/
	virtual	value_ptr		rotate_tree_sub(value_ptr node, value_ptr key, node_ptr swapkey)
	{
		IRIS_UNUSED_VARIABLE(node);
		IRIS_UNUSED_VARIABLE(key);
		IRIS_UNUSED_VARIABLE(swapkey);
		return this->m_root;
	}

};

}	// end of namespace fnd
}	// end of namespace iris

#endif
