//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndAutoSingleton.h
 * @brief		VOgNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndAutoSingleton_H_
#define INCG_IRIS_FndAutoSingleton_H_

//======================================================================
// include
#include "FndRefPtr.h"
#include "../../iris_debug.h"

namespace iris {
namespace fnd
{

//======================================================================
// class

/**
 * @brief	QƃJE^VOgNX
 *
 * @note	CX^XjĂAQƂ葶݂ۏ؂܂B
 * @note	AQƃJE^NX̊gz肵āAtemplateĂB
 *			
 * @tparam	_TC			= ΏۃNX^
 * @tparam	_NUM_INST	= CX^X̌
 * @tparam	_Reference	= _TC̃t@X^
 * @tparam	_Instance	= CX^X̌^
*/
template<class _TC, s32 _NUM_INST=1
, typename _Reference = CRefPtr< _TC, CLiberatorCRTP<_TC>, CNewAllocator<_TC> >
, typename _Instance  = _Reference >
class CAutoSingleton : public INonCopyable<>
{
	IRIS_STATIC_ASSERT( _NUM_INST > 0 );
public:
	static const u32	NUM_INST = _NUM_INST;
public:
	typedef _TC			value_type;		//!< VOgɂNX
	typedef _TC			*value_ptr;		//!< VOgNX|C^[
	typedef _TC			&value_ref;		//!< VOgNXQ
	typedef const _TC	*const_ptr;
	typedef const _TC	&const_ref;
	typedef	_Reference	ref_ptr;		//!< VOg̃AhXۑz^
	typedef _Instance	instance;		//!< CX^X^

private:
	s32	m_idx;	//!< CX^XCfbNX

public:
	/// CX^X̗L
	static s32			is_valid(s32 idx=0)			{ return ptr(idx).is_valid(); }
	/// CX^X̎擾
	static instance		GetInstance(s32 idx=0)		{ IRIS_ASSERT( ptr(idx).is_valid() ); return ptr(idx); }
	/// CX^XAhX̎擾
	static value_ptr	GetInstancePtr(s32 idx=0)	{ return ptr(idx).ptr(); }
	/// CX^X̑擾
	static s32			GetInstanceNum(void)		{ return NUM_INST; }

public:
	/// CfbNX̎擾
	s32					GetIndex(void)	const		{ return m_idx; }

protected:
	/// RXgN^
	/// @note	CreateInstanceƂp
	CAutoSingleton(void) 
		: m_idx(-1)
	{
	}
	/// RXgN^
	/// @note	[U[CX^XƂɎœo^
	explicit	CAutoSingleton(s32 idx)
		: m_idx(idx)
	{
		s32w64 ofs = (s32w64)(value_ptr)1 - (s32w64)(CAutoSingleton<value_type>*)(value_ptr)1;
		RegisterInstance(idx, (value_ptr)(((s32w64)this + ofs)));
	}
	/// fXgN^
	/// @note	ƂDeleteInstance邱
	virtual ~CAutoSingleton(void)
	{
	}

private:
	static void RegisterInstance(s32 idx, value_ptr addr)
	{
#ifdef _IRIS_DEBUG
//		if( ptr(idx).is_valid() ) IRIS_WARNING("The instance already exists.This instance is annulled when the reference is lost.");
		IRIS_ASSERT( ptr(idx).is_invalid() );
#endif
		ptr(idx) = addr;
	}

public:
	/// CX^X̐
	template<class Fuctory>
	static instance	CreateInstance(s32 idx=0)	
	{ 
		value_ptr p = Fuctory::createInstance();
		if( p != nullptr ) p->m_idx = idx;
		RegisterInstance(idx, p);
		return GetInstance(idx);
	}
	static instance	CreateInstance(s32 idx=0)	
	{ 
		value_ptr p = value_type::createInstance();
		if( p != nullptr ) p->m_idx = idx;
		RegisterInstance(idx, p);
		return GetInstance(idx); 
	}
	/// CX^X̔j
	static void		DeleteInstance(s32 idx=0)	{ ptr(idx) = ref_ptr::null(); }

public:
	static value_ptr	createInstance(void)		{ return new value_type; }
	static void*		deleteInstance(void* ptr)	{ delete static_cast<value_ptr>(ptr); return nullptr; }

public:
	/// liberatorpliberate֐
	static void*	do_liberate(void* ptr)		{ return value_type::deleteInstance(ptr); }

private:
	static ref_ptr& ptr(s32 idx)
	{
		static ref_ptr s_instance[NUM_INST];
		IRIS_ASSERT( idx >= 0 && idx < NUM_INST );
		return s_instance[idx];
	}
};

}	// end of namespace fnd
}	// end of namespace iris

#endif
