//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndTwofish.h
 * @brief		twofishÍNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndTwofish_H_
#define INCG_IRIS_FndTwofish_H_

//======================================================================
// include
#include "FndCipherBase.h"
#include "../../iris_debug.h"

namespace iris {
namespace fnd
{

//======================================================================
// define
// NX肷
// prefix
//#define _IRIS_TWOFISH_KEY		128

//======================================================================
// declare
template<u32 _KYB> class CTwofish;

//======================================================================
// typedef
typedef class CTwofish<128>		CTwofish128;	//!< twofishÍNX(key=128)
typedef class CTwofish<192>		CTwofish192;	//!< twofishÍNX(key=192)
typedef class CTwofish<256>		CTwofish256;	//!< twofishÍNX(key=256)

#ifdef _IRIS_TWOFISH_KEY
typedef class CTwofish<_IRIS_TWOFISH_KEY>	CDefTwofish;	//!< ftHgݒtwofishÍNX
#else
typedef class CTwofish<128>					CDefTwofish;	//!< ftHgݒtwofishÍNX
#endif

//======================================================================
// class
/**
 * @brief	twofishÍNX
 * @param _KYB	= rbg
*/
template<u32 _KYB>
class CTwofish : public IBlockCipher
{
public:
	typedef enum
	{
		NR			= 16,			//!< Eh
		KBITS		= _KYB,			//!< rbg
		NK			= KBITS/32,		//!< [h
		NK64		= KBITS/64,		//!< 64bit
		KEYSIZE		= KBITS/8,		//!< oCg

		BBITS		= 128,			//!< ubNrbg
		NB			= 4,			//!< ubN[h
		BLOCKSIZE	= 16,			//!< ubNoCg

		KS_LENGTH	= NB+NB+NR*2,	//!< L[XPW[[h
		KS_IN_OFS	= 0,
		KS_OUT_OFS	= KS_IN_OFS +NB,
		KS_ROUND_OFS= KS_OUT_OFS+NB,

		SB_SIZE		= NK64
	} TYPES;

private:
	IRIS_STATIC_ASSERT( (KBITS == 128) || (KBITS == 192) || (KBITS == 256) );

	u32		m_KeySch[KS_LENGTH];	//!< key schedule
	u32		m_SB[SB_SIZE];			//!< S-Box

public:
	// RXgN^
	CTwofish(void);

public:
	/// ubNoCg̎擾
	virtual u32		GetBlockSize(void)	const	{ return BLOCKSIZE; }
	/**
	 * @brief	oCg̎擾
	 * @note	Ɍ܂ĂȂ
	*/
	virtual u32		GetKeySize(void)	const	{ return FREESIZE; }
public:
	// ̍쐬
	virtual bool	CreateKeys(const u8* pKey, u32 nSize);
public:
	// Í
	virtual bool	EncryptBlock(u8* dst, const u8* src); 
	// 
	virtual bool	DecryptBlock(u8* dst, const u8* src); 

private:
	// 
	u32		Substitution(u32 x, const u32* key);
};


}	// end of namespace fnd
}	// end of namespace iris

#endif
