//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndCipherBase.h
 * @brief		ÍNXx[Xt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndCipherBase_H_
#define INCG_IRIS_FndCipherBase_H_

//======================================================================
// include
#include "../../iris_object.h"

namespace iris {
namespace fnd
{

//======================================================================
// class
/// ubNÍNXC^[tFCX
class IBlockCipher : public IIrisObject
{
public:
	enum
	{
		FREESIZE	= 0xFFFFFFFF
	};
public:
	/// RXgN^
	IBlockCipher(void) {}
public:
	/// ubNoCg̎擾
	virtual u32		GetBlockSize(void)	const	= 0;
	/// oCg̎擾
	virtual u32		GetKeySize(void)	const	= 0;
public:
	/**
	 * @brief	̍쐬
	 * @param [in]	pKey	= z
	 * @param [in]	nSize	= zTCY
	*/
	virtual bool	CreateKeys(const u8* pKey, u32 nSize)		= 0;
	/**
	 * @brief	ubNÍ
	 * @note	dst == src ł\Ȃ悤ɂKv
	 *			dst  nSizeŎTCYȏ̗̈KvƂBdst̃TCYꍇ͕̋ۏ؂ȂB
	*/
	virtual	bool	EncryptBlock(u8* dst, const u8* src)		= 0; 
	/**
	 * @brief	ubN
	 * @note	dst == src ł\Ȃ悤ɂKvB
	 *			dst  nSizeŎTCYȏ̗̈KvƂBdst̃TCYꍇ͕̋ۏ؂ȂB
	*/
	virtual	bool	DecryptBlock(u8* dst, const u8* src)		= 0;

	/// Í(ECB)
	virtual	bool	Encrypt(u8* dst, const u8* src, u32 nSize)
	{
		const u8* ps = src;
		u8* pd = dst;
		u32 bs = GetBlockSize();
		if( nSize % bs != 0 ) return false;
		for( u32 i=0, n = nSize/bs; i < n; ++i, ps+=bs, pd+=bs )
		{
			EncryptBlock(pd, ps);
		}
		return true;
	}
	/// (ECB)
	virtual	bool	Decrypt(u8* dst, const u8* src, u32 nSize)
	{
		u32 bs = GetBlockSize();
		const u8* ps = src;
		u8* pd = dst;
		if( nSize % bs != 0 ) return false;
		for( u32 i=0, n = nSize/bs; i < n; ++i, ps+=bs, pd+=bs )
		{
			DecryptBlock(pd, ps);
		}
		return true;
	}
};

}	// end of namespace fnd
}	// end of namespace iris

#endif
