//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndBlowfish.h
 * @brief		blowfishÍNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndBlowfish_H_
#define INCG_IRIS_FndBlowfish_H_

//======================================================================
// include
#include "FndCipherBase.h"

namespace iris {
namespace fnd
{

//======================================================================
// class
/// blowfishÍNX
class CBlowfish : public IBlockCipher
{
public:
	typedef enum
	{
		NR			= 16,	//!< Eh
		BLOCKSIZE	= 8,	//!< ubNoCg

		KEYSIZE		= 16	//!< K
	} TYPES;

private:
	u32		m_PB[NR+2];		//!< P-Box
	u32		m_SB[4][256];	//!< S-Box

public:
	// RXgN^
	CBlowfish(void);

public:
	/// ubNoCg̎擾
	virtual u32		GetBlockSize(void)	const		{ return BLOCKSIZE; }
	/**
	 * @brief	oCg̎擾
	 * @note	Ɍ܂ĂȂ
	*/
	virtual u32		GetKeySize(void)	const		{ return FREESIZE; }
public:
	// ̍쐬
	virtual bool	CreateKeys(const u8* pKey, u32 nSize);
public:
	// Í
	virtual bool	EncryptBlock(u8* dst, const u8* src); 
	// 
	virtual bool	DecryptBlock(u8* dst, const u8* src); 

private:
	// 
	u32		Substitution(u32 x);
};


}	// end of namespace fnd
}	// end of namespace iris

#endif
