//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndBase64.cpp
 * @brief		Base64ϊ֐t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_FndBase64_CPP_

//======================================================================
// include
#include "FndBase64.h"

namespace iris {
namespace fnd
{

//======================================================================
// prototype
static inline u8 convtotxt(u8 c);
static inline u8 convtobase(u8 c);

/**********************************************************************//**
 *
 * base64ɃfR[h
 *
 ----------------------------------------------------------------------
 * @param [out]	pDst		= o̓obt@
 * @param [in]	dst_size	= pDst̃TCY
 * @param [in]	pSrc		= ̓obt@
 * @param [in]	src_size	= pSrc̃TCY
 * @return	񂾃TCYiKvȃTCYj(NULL͊܂߂Ȃ)
*//***********************************************************************/
u32 DecodeBase64(u8* pDst, u32 dst_size, const u8* pSrc, u32 src_size)
{
	u32 rsize = 0;
	if( pSrc == nullptr )	return 0;
	if( src_size == 0 ) return 0;
	if( pDst == nullptr ) return src_size/4*3;

	u8 c[4];
	for(u32 i=0; i < src_size; i+=4)
	{
		int j;
		
		// 'A'`'Z'C'a'`'z'C'0'`'9'C'+'C'/fC
		// 0`63̐lɕϊB
		for(j=0; j < 4 && i+j < src_size; ++j)
		{
			*(c+j) = convtotxt(*(pSrc+i+j));
		}
		
		// 6rbgl4C8rbgl3ɕϊ
		if(j > 1) 
		{
			++rsize;
			if( rsize > dst_size ) goto decode_error;
			*(pDst++) = (u8)( (((*c)<<2) & 0xfc) 
								| (((*(c+1))>>4) & 0x03) );
		}
		if(j > 2)
		{
			++rsize;
			if( rsize > dst_size ) goto decode_error;
			*(pDst++) = (u8)( (((*(c+1))<<4) & 0xf0)
								| (((*(c+2))>>2) & 0x0f) );
		}
		if(j > 3)
		{
			++rsize;
			if( rsize > dst_size ) goto decode_error;
			*(pDst++) = (u8)( (((*(c+2))<<6) & 0xc0)
								| ((*(c+3)) & 0x3f) );
		}
	}

#ifdef UNICODE
	if( rsize + 2 + (rsize&0x1) > dst_size ) return rsize;
	if( rsize & 0x1 ) ++pDst;
	*(u16*)pDst = L'\0';
#else
	if( rsize+1 > dst_size ) return rsize;
	*pDst = '\0';
#endif
decode_error:
	return rsize;
}

/**********************************************************************//**
 *
 * base64ɃGR[h
 *
 ----------------------------------------------------------------------
 * @param [out]	pDst		= o(OUT)
 * @param [in]	dst_size	= pDst̃TCY
 * @param [in]	pSrc		= ̓obt@(IN)
 * @param [in]	src_size	= pSrc̃TCY
 * @param [in]	Head		= wb_Atb^̗L
 * @return	񂾃TCYiKvȃTCYj(NULL͊܂߂Ȃ)
*//***********************************************************************/
u32 EncodeBase64(u8* pDst, u32 dst_size, const u8* pSrc, u32 src_size)
{
	u32 rsize = 0;
	if( pSrc == nullptr ) return 0;
	if( pDst == pSrc ) return 0;
	if( src_size == 0 ) return 0;
	if( pDst == nullptr ) return (src_size+2)/3*4;

	u8 c[3], d[4];
	for(u32 i=0; i < src_size; i+=3)
	{
		int j;

		// 3o
		for(j=0; j<3; ++j) *(c+j) = (u8)(i+j < src_size ? *(pSrc+i+j) : 0);
		
		// 8rbgl3C6rbgl4ɕϊ
		*d		= (u8)( (((*(c  ))>>2) & 0x3f) );
		*(d+1)	= (u8)( (((*(c  ))<<4) & 0x30) | (((*(c+1))>>4) & 0x0f) );
		*(d+2)	= (u8)( (((*(c+1))<<2) & 0x3c) | (((*(c+2))>>6) & 0x03) );
		*(d+3)	= (u8)( (((*(c+2))   ) & 0x3f) );

		// 0`63̐lC
		// 'A'`'Z'C'a'`'z'C'0'`'9'C'+'C'/fɕϊ
		for(j=0; j < 4; ++j) 
		{
			*(d+j) = convtobase(*(d+j));
		}

		// ʂ𕶎ɒǉF
		// 4̔{ɂȂ悤ɁC
		// KvɉĖ'='
		rsize += 4;
		if( rsize > dst_size ) goto encode_error;
		*pDst++ = *d;
		*pDst++ = *(d+1);
		*pDst++ = (u8)( i+1 < src_size ? *(d+2) : '=' );
		*pDst++ = (u8)( i+2 < src_size ? *(d+3) : '=' );
	}

#ifdef UNICODE
	if( rsize + 2 + (rsize&0x1) > dst_size ) return rsize;
	if( rsize & 0x1 ) ++pDst;
	*(u16*)pDst = L'\0';
#else
	if( rsize+1 > dst_size ) return rsize;
	*pDst = '\0';
#endif
encode_error:
	return rsize;
}

/**********************************************************************//**
 *
 * base64ɃGR[hiwb_Atb^tj
 *
 ----------------------------------------------------------------------
 * @param [out]	pDst		= o(OUT)
 * @param [in]	dst_size	= pDst̃TCY
 * @param [in]	pSrc		= ̓obt@(IN)
 * @param [in]	src_size	= pSrc̃TCY
 * @param [in]	Head		= wb_Atb^̗L
 * @return	񂾃TCYiKvȃTCYj(NULL͊܂߂Ȃ)
*//***********************************************************************/
u32 EncodeBase64Head(u8* pDst, u32 dst_size, const u8* pSrc, u32 src_size)
{
	u32 rsize = 16;
	if( pDst != nullptr ) 
	{
		if( rsize < dst_size ) return 0;
		char head[] = BASE64_HEADA;
		memcpy(pDst, head, sizeof(head));
		pDst += 16;
	}
	u32 ret = EncodeBase64(pDst, dst_size-rsize, pSrc, src_size);
	rsize += ret;
	rsize += 2;
	if( pDst != nullptr ) 
	{
		if( rsize < dst_size ) return 0;
		pDst += ret;
		*pDst++ = '?';
		*pDst++ = '=';
		if( rsize+1 < dst_size ) *pDst++ = '\0';
	}
	return rsize;
}

/**********************************************************************//**
 *
 * ϊ(BASE64->TEXT)
 *
 ----------------------------------------------------------------------
 * @param [in]	c	= 
 * @return	o
*//***********************************************************************/
u8 convtotxt(u8 c)
{
	if('A' <= c && c <= 'Z')
		return (u8)(c - 'A');
	if('a' <= c && c <= 'z')
		return (u8)(c - 'a' + 26);
	if('0' <= c && c <= '9')
		return (u8)(c - '0' + 52);
	if(c == '+') return 62;
	if(c == '/') return 63;
	return (u8)'\0';
}

/**********************************************************************//**
 *
 * ϊ(TEXT->BASE64)
 *
 ----------------------------------------------------------------------
 * @param [in]	c	= 
 * @return	o
*//***********************************************************************/
u8 convtobase(u8 c)
{
	if(c <= 0x19)
		return (u8)(c + 'A');
	if(c >= 0x1a && c <= 0x33)
		return (u8)(c  + 'a'- 0x1a);
	if(c >= 0x34 && c <= 0x3d)
		return (u8)(c  + '0'- 0x34);
	if(c == 0x3e)
		return (u8)'+';
	if(c == 0x3f)
		return (u8)'/';
	return (u8)'=';
}

}	// end of namespace fnd
}	// end of namespace iris

#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
#include "../../unit/UnitCore.h"
#include "iris_using.h"
#include "../../iris_iostream.h"
#include <stdio.h>
#include <string.h>
#include <tchar.h>

//======================================================================
// test
IRIS_UNITTEST(CFndBase64UnitTest, FndBase64UnitTest)
{
#define BUF_LEN			256
#define BUF_BASELEN		(BUF_LEN+2)/3*4+1
	TCHAR buf[BUF_LEN] = TEXT("test");
	TCHAR base[BUF_BASELEN];
	TCHAR out[BUF_LEN] = TEXT("test");

#ifndef _IRIS_SUPPORT_AUTO_UNITTEST
	std::cout << "ϊ镶͂ĂB" << std::endl;
	std::tcin >> buf;
#else
#endif
	{
		EncodeBase64((u8*)base, BUF_BASELEN, (u8*)buf, (u32)_tcslen(buf)*sizeof(TCHAR));

		_tprintf(base);
		_tprintf(IRIS_TEXT("\n"));

		DecodeBase64((u8*)out, BUF_LEN, (u8*)base, (u32)_tcslen(base)*sizeof(TCHAR));

		_tprintf(out);
		_tprintf(IRIS_TEXT("\n"));

		IRIS_ASSERT( _tcscmp(buf, out) == 0 );
	}
}

#endif	// #if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
