//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndBase16.cpp
 * @brief		Base32ϊ֐t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_FndBase16_CPP_

//======================================================================
// include
#include "FndBase16.h"

namespace iris {
namespace fnd
{

//======================================================================
// prototype
static inline u8 convtotxt(u8 c);
static inline u8 convtobase16(u8 c);

/**********************************************************************//**
 *
 * base16ɃfR[h
 *
 ----------------------------------------------------------------------
 * @param [out]	pDst		= o̓obt@
 * @param [in]	dst_size	= pDst̃TCY
 * @param [in]	pSrc		= ̓obt@
 * @param [in]	src_size	= pSrc̃TCY
 * @return	񂾃TCYiKvȃTCYj(NULL͊܂߂Ȃ)
*//***********************************************************************/
u32 DecodeBase16(u8* pDst, u32 dst_size, const u8* pSrc, u32 src_size)
{
	u32 rsize = 0;
	if( pSrc == nullptr )	return 0;
	if( src_size == 0 ) return 0;
	if( pDst == nullptr ) return src_size/2;

	u8 c[2];
	for(u32 i=0; i < src_size; i+=2)
	{
		int j;
		for(j=0; j < 2 && i+j < src_size; ++j)
		{
			*(c+j) = convtotxt(*(pSrc+i+j));
		}
		
		// 4rbgl2C8rbgl1ɕϊ
		++rsize;
		if( rsize > dst_size ) goto decode_error;
		*(pDst)	 = (u8)( (((*c)<<4) & 0xf0) 
						| ((*(c+1)) & 0x0f) );
		++pDst;
	}

#ifdef UNICODE
	if( rsize + 2 + (rsize&0x1) > dst_size ) return rsize;
	if( rsize & 0x1 ) ++pDst;
	*(u16*)pDst = L'\0';
#else
	if( rsize+1 > dst_size ) return rsize;
	*pDst = '\0';
#endif
decode_error:
	return rsize;
}

/**********************************************************************//**
 *
 * base16ɃGR[h
 *
 ----------------------------------------------------------------------
 * @param [out]	pDst		= o(OUT)
 * @param [in]	dst_size	= pDst̃TCY
 * @param [in]	pSrc		= ̓obt@(IN)
 * @param [in]	src_size	= pSrc̃TCY
 * @param [in]	Head		= wb_Atb^̗L
 * @return	񂾃TCYiKvȃTCYj(NULL͊܂߂Ȃ)
*//***********************************************************************/
u32 EncodeBase16(u8* pDst, u32 dst_size, const u8* pSrc, u32 src_size)
{
	u32 rsize = 0;
	if( pSrc == nullptr ) return 0;
	if( pDst == pSrc ) return 0;
	if( src_size == 0 ) return 0;
	if( pDst == nullptr ) return src_size*2;

	u8 d[2];
	for(u32 i=0; i < src_size; ++i)
	{
		u8 c = *(pSrc+i);
		
		*d		= (u8)( ((c>>4) & 0x0f) );
		*(d+1)	= (u8)( ((c   ) & 0x0f) );

		// ʂ𕶎ɒǉF
		rsize += 2;
		if( rsize > dst_size ) goto encode_error;
		for(int j=0; j < 2; ++j) 
		{
			*pDst++ = convtobase16(*(d+j));
		}
	}

#ifdef UNICODE
	if( rsize + 2 + (rsize&0x1) > dst_size ) return rsize;
	if( rsize & 0x1 ) ++pDst;
	*(u16*)pDst = L'\0';
#else
	if( rsize+1 > dst_size ) return rsize;
	*pDst = '\0';
#endif
encode_error:
	return rsize;
}

/**********************************************************************//**
 *
 * ϊ(BASE16->TEXT)
 *
 ----------------------------------------------------------------------
 * @param [in]	c	= 
 * @return	o
*//***********************************************************************/
u8 convtotxt(u8 c)
{
	if('0' <= c && c <= '9')
		return (u8)(c - '0');
	if('A' <= c && c <= 'F')
		return (u8)(c - 'A' + 10);
	return '\0';
}

/**********************************************************************//**
 *
 * ϊ(TEXT->BASE16)
 *
 ----------------------------------------------------------------------
 * @param [in]	c	= 
 * @return	o
*//***********************************************************************/
u8 convtobase16(u8 c)
{
	if( c <= 0x9 ) return (u8)(c + '0');
	if( 0xa <= c && c <= 0xf ) return (u8)(c + 'A' - 0xa);
	return '=';
}

}	// end of namespace fnd
}	// end of namespace iris

#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
#include "../../unit/UnitCore.h"
#include "iris_using.h"
#include "../../iris_iostream.h"
#include <stdio.h>
#include <tchar.h>

//======================================================================
// test
IRIS_UNITTEST(CFndBase16UnitTest, FndBase16UnitTest)
{
#define BUF_LEN			256
#define BUF_BASELEN		(BUF_LEN)*2+1
	TCHAR buf[BUF_LEN] = TEXT("test");
	TCHAR base[BUF_BASELEN];
	TCHAR out[BUF_LEN] = TEXT("test");

#ifndef _IRIS_SUPPORT_AUTO_UNITTEST
	std::cout << "ϊ镶͂ĂB" << std::endl;
	std::tcin >> buf;
#else
#endif
	{
		EncodeBase16((u8*)base, BUF_BASELEN, (u8*)buf, (u32)_tcslen(buf)*sizeof(TCHAR));

		_tprintf(base);
		_tprintf(IRIS_TEXT("\n"));

		DecodeBase16((u8*)out, BUF_LEN, (u8*)base, (u32)_tcslen(base)*sizeof(TCHAR));

		_tprintf(out);
		_tprintf(IRIS_TEXT("\n"));

		IRIS_ASSERT( _tcscmp(buf, out) == 0 );
	}
}

#endif	// #if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
