//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		cpp0x_volatile_traits.hpp
 * @brief		volatile t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_cpp0x_volatile_traits_HPP_
#define INCG_IRIS_cpp0x_volatile_traits_HPP_

//======================================================================
// include
#include "cpp0x_type_traits_def.hpp"

namespace cpp0x
{

//======================================================================
// declare
template<typename _TN>class is_volatile;		// volatileǂ
template<typename _TN>class add_volatile;		// _TN  volatileǉ
template<typename _TN>class remove_volatile;	// _TNvolatile폜

//======================================================================
// class
/// is volatile
template<typename _TN>
class is_volatile 
{
	template<typename _TT> struct volatile_trait : public iml::detail::false_type	{};
	template<typename _TT> struct volatile_trait<volatile _TT> : public iml::detail::true_type	{};
	template<typename _TT> struct volatile_trait<volatile _TT*> : public iml::detail::true_type	{};
public:
	enum { value = volatile_trait<_TN>::value };
};

/// add volatile trait
IRIS_SET_TYPE_TRAITS_DEC(add_volatile, volatile);
/// remove volatile trait
IRIS_REMOVE_TYPE_TRAITS_DEC(remove_volatile, volatile);

}	// end of namespace cpp0x

//======================================================================
// include
#include "cpp0x_type_traits_undef.hpp"

#endif
