//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		cpp0x_type_traits_def.hpp
 * @brief		type_traits t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_cpp0x_type_traits_def_HPP_
#define INCG_IRIS_cpp0x_type_traits_def_HPP_

//======================================================================
// include
#include "cpp0x_type_traits_detail.hpp"

//======================================================================
// define
// B̌^f
#if defined(_MSC_VER) && (_MSC_VER <= 1200)		// VC6.0ȑÓAꉻłȂ
#define IRIS_IS_TYPE_TRAITS_DEC(name, _type)				\
	template<typename _TN>									\
	class name												\
	{														\
		template<typename _TT> struct name##_trait			\
			: public iml::detail::false_type	{};			\
		template<> struct name##_trait<_type>				\
			: public iml::detail::true_type		{};			\
		typedef typename remove_cv<_TN>::type	type;		\
	public:													\
		enum { value = name##_trait<type>::value };			\
	}
#else
#define IRIS_IS_TYPE_TRAITS_DEC(name, _type)						\
	template<typename _TN>											\
	class name														\
	{																\
		template<typename _TT, typename _TMP> struct name##_trait	\
			: public iml::detail::false_type	{};					\
		template<typename _TMP> struct name##_trait<_type, _TMP>	\
			: public iml::detail::true_type		{};					\
		typedef typename remove_cv<_TN>::type	type;				\
	public:															\
		enum { value = name##_trait<type, type>::value };			\
	}
#endif

// ̒ǉiłɓĂꍇ͉Ȃj
#define IRIS_SET_TYPE_TRAITS_DEC(name, trait)					\
	template<typename _TN>										\
	class name													\
	{															\
		template<typename _TT> struct name##_trait				\
		{														\
			typedef _TT	trait	type;							\
		};														\
		template<typename _TT> struct name##_trait<_TT trait>	\
		{														\
			typedef _TT	trait	type;							\
		};														\
	public:														\
		typedef typename name##_trait<_TN>::type	type;		\
	}

// ̒ǉ
#define IRIS_ADD_TYPE_TRAITS_DEC(name, trait)					\
	template<typename _TN>										\
	class name													\
	{															\
		template<typename _TT> struct name##_trait				\
		{														\
			typedef _TT	trait	type;							\
		};														\
	public:														\
		typedef typename name##_trait<_TN>::type	type;		\
	}

// ̍폜
#define IRIS_REMOVE_TYPE_TRAITS_DEC(name, trait)				\
	template<typename _TN>										\
	class name													\
	{															\
		template<typename _TT> struct name##_trait				\
		{														\
			typedef _TT		type;								\
		};														\
		template<typename _TT> struct name##_trait<_TT trait>	\
		{														\
			typedef _TT		type;								\
		};														\
	public:														\
		typedef typename name##_trait<_TN>::type	type;		\
	}

#endif
