//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		cpp0x_trivial_traits.hpp
 * @brief		I t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_cpp0x_trivial_traits_HPP_
#define INCG_IRIS_cpp0x_trivial_traits_HPP_

//======================================================================
// include
#include "cpp0x_cv_traits.hpp"
#include "cpp0x_pod_traits.hpp"
#include "../../ml/iml_op.hpp"

namespace cpp0x
{

//======================================================================
// declare
template<typename _TN>class has_trivial_constructor;	// IȃRXgN^邩
template<typename _TN>class has_trivial_copy;			// IȃRs[RXgN^邩
template<typename _TN>class has_trivial_assign;			// Iȑ邩
template<typename _TN>class has_trivial_destructor;		// IȃfXgN^邩

//======================================================================
// class
/// has trivial constructor
template<typename _TN>
class has_trivial_constructor
{
public:
	enum { value = iml::op_or< is_pod<_TN>::value
					, IRIS_HAS_TRIVIAL_CONSTRUCTOR(_TN) >::value };
};

/// has trivial copy
template<typename _TN>
class has_trivial_copy
{
public:
	enum { value = iml::op_and< iml::op_or< is_pod<_TN>::value
								, IRIS_HAS_TRIVIAL_COPY(_TN) >::value
						, iml::op_not< is_volatile<_TN>::value >::value
					>::value };
};

/// has trivial assign
template<typename _TN>
class has_trivial_assign
{
public:
	enum { value = iml::op_and< iml::op_or< is_pod<_TN>::value
								, IRIS_HAS_TRIVIAL_ASSIGN(_TN) >::value
						, iml::op_not< is_const<_TN>::value >::value
						, iml::op_not< is_volatile<_TN>::value >::value
					>::value };
};

/// has trivial destructor
template<typename _TN>
class has_trivial_destructor
{
public:
	enum { value = iml::op_or< is_pod<_TN>::value
					, IRIS_HAS_TRIVIAL_DESTRUCTOR(_TN) >::value };
};
}	// end of namespace cpp0x

#endif
