//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		cpp0x_rank_traits.hpp
 * @brief		z t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_cpp0x_rank_traits_HPP_
#define INCG_IRIS_cpp0x_rank_traits_HPP_

//======================================================================
// include
#include "cpp0x_cv_traits.hpp"

namespace cpp0x
{

//======================================================================
// declare
template<typename _TN>class rank;			// z̎

//======================================================================
// class
/// rank
template<typename _TN>
class rank
{
	template<typename _TT, size_t N>
	struct rank_trait { enum { value = N }; };

	template<typename _TT, size_t R, size_t N>
	struct rank_trait<_TT[R], N> { enum { value = rank_trait<_TT, N+1>::value }; };

#if	!defined(__MWERKS__)
	template<typename _TT, size_t N>
	struct rank_trait<_TT[], N> { enum { value = rank_trait<_TT, N+1>::value }; };
#endif

	typedef typename remove_cv<_TN>::type	type;
public:
	enum { value = rank_trait<type, 0>::value };
};

}	// end of namespace cpp0x

#endif
