//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		cpp0x_polymorphic_traits.hpp
 * @brief		z֐ t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_cpp0x_polymorphic_traits_HPP_
#define INCG_IRIS_cpp0x_polymorphic_traits_HPP_

//======================================================================
// include
#include "cpp0x_class_traits.hpp"
#include "cpp0x_cv_traits.hpp"
#include "../../ml/op/iml_op_or.hpp"

namespace cpp0x
{

//======================================================================
// declare
template<typename _TN>class is_polymorphic;		// z֐Ă邩ǂ

//======================================================================
// class
/// is polymorphic
template<typename _TN>
class is_polymorphic
{
	template<class _TT>struct is_polymorphic_impl1
	{
		typedef typename remove_cv<_TT>::type	ncvt;
		struct d1 : public ncvt
		{
			d1();
#if	!defined(__GNUC__) && !defined(_MSC_VER) && !defined(__MWERKS__) && !defined(__EDG__)
			~d1() throw;
#endif
			char	padding[256];
		};
		struct d2 : public ncvt
		{
			d2();
			virtual ~d2();
#if	!defined(_MSC_VER) && !defined(__ICL) && !defined(__MWERKS__)
			struct unique {};
			virtual void unique_name_to_iris5487629(unique*);
#endif
			char	padding[256];
		};
		enum { value = (sizeof(d1) == sizeof(d2)) };
	};

	template<class _TT>struct is_polymorphic_impl2 : public ::iml::detail::false_type {};

	template<bool ic, typename TMP>struct is_polymorphic_select
	{
		template<class _TT>struct rebind { typedef is_polymorphic_impl2<_TT> type; };
	};
	template<typename TMP>struct is_polymorphic_select<true, TMP>
	{
		template<class _TT>struct rebind { typedef is_polymorphic_impl1<_TT> type; };
	};

	template<typename _TT>struct is_polymorphic_impl
	{
		typedef is_polymorphic_select< is_class<_TT>::value, void >	selector;
		typedef typename selector::template rebind<_TT>				binder;
		typedef typename binder::type								type;
		enum { value = type::value };
	};

public:
	enum { value = is_polymorphic_impl<_TN>::value };
};

}	// end of namespace cpp0x

#endif
