//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		cpp0x_pod_traits.hpp
 * @brief		POD^ t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_cpp0x_pod_traits_HPP_
#define INCG_IRIS_cpp0x_pod_traits_HPP_

//======================================================================
// include
#include "cpp0x_scalar_traits.hpp"
#include "cpp0x_void_traits.hpp"
#include "../../ml/op/iml_op_or.hpp"

namespace cpp0x
{

//======================================================================
// declare
template<typename _TN>class is_pod;	// POD^ǂ

//======================================================================
// class
/// is same
template<typename _TN>
class is_pod
{
	template<typename _TT> struct pod_trait
	{
		enum { value = iml::op_or< is_scalar<_TT>::value
					, is_void<_TT>::value
					, IRIS_IS_POD(_TT) >::value };
	};
	template<typename _TT, size_t sz> struct pod_trait<_TT[sz]> : public pod_trait<_TT> {};

	typedef typename remove_cv<_TN>::type	type;
public:
	enum { value = pod_trait<type>::value };
};

}	// end of namespace cpp0x

#endif
