//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		cpp0x_nothrow_traits.hpp
 * @brief		OX[ t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_cpp0x_nothrow_traits_HPP_
#define INCG_IRIS_cpp0x_nothrow_traits_HPP_

//======================================================================
// include
#include "cpp0x_trivial_traits.hpp"

namespace cpp0x
{

//======================================================================
// declare
template<typename _TN>class has_nothrow_constructor;	// RXgN^OX[邩ǂ
template<typename _TN>class has_nothrow_copy;			// Rs[RXgN^OX[邩ǂ
template<typename _TN>class has_nothrow_assign;			// OX[邩ǂ

//======================================================================
// class
/// has nothrow constructor
template<typename _TN>
class has_nothrow_constructor
{
public:
	enum { value = iml::op_or< has_trivial_constructor<_TN>::value
						, IRIS_HAS_NOTHROW_CONSTRUCTOR(_TN) >::value };
};

/// has nothrow copy
template<typename _TN>
class has_nothrow_copy
{
public:
	enum { value = iml::op_or< has_trivial_copy<_TN>::value
						, IRIS_HAS_NOTHROW_COPY(_TN) >::value };
};

/// has nothrow assign
template<typename _TN>
class has_nothrow_assign
{
public:
	enum { value = iml::op_or< has_trivial_assign<_TN>::value
						, IRIS_HAS_NOTHROW_ASSIGN(_TN) >::value };
};

}	// end of namespace cpp0x

#endif
