//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		cpp0x_function_traits.hpp
 * @brief		֐ t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_cpp0x_function_traits_HPP_
#define INCG_IRIS_cpp0x_function_traits_HPP_

//======================================================================
// include
#include "cpp0x_pointer_traits.hpp"

namespace cpp0x
{

//======================================================================
// declare
template<typename _TN>class is_function;			// ֐ǂ
template<typename _Function>class function_traits;	// ֐

//======================================================================
// class
/// is function
template<typename _TN>
class is_function
{
	template<typename _TT> struct function_trait : public iml::detail::false_type {};
	template<typename _TT> struct function_trait< _TT(void) > : public iml::detail::true_type {};
	template<typename _TT> struct function_trait< _TT(...) > : public iml::detail::true_type {};

	template<typename _TT, typename _A1>
	struct function_trait< _TT(_A1) > : public iml::detail::true_type {};
	template<typename _TT, typename _A1>
	struct function_trait< _TT(_A1, ...) > : public iml::detail::true_type {};

	template<typename _TT, typename _A1, typename _A2>
	struct function_trait< _TT(_A1, _A2) > : public iml::detail::true_type {};
	template<typename _TT, typename _A1, typename _A2>
	struct function_trait< _TT(_A1, _A2, ...) > : public iml::detail::true_type {};

	template<typename _TT, typename _A1, typename _A2, typename _A3>
	struct function_trait< _TT(_A1, _A2, _A3) > : public iml::detail::true_type {};
	template<typename _TT, typename _A1, typename _A2, typename _A3>
	struct function_trait< _TT(_A1, _A2, _A3, ...) > : public iml::detail::true_type {};

	template<typename _TT, typename _A1, typename _A2, typename _A3, typename _A4>
	struct function_trait< _TT(_A1, _A2, _A3, _A4) > : public iml::detail::true_type {};
	template<typename _TT, typename _A1, typename _A2, typename _A3, typename _A4>
	struct function_trait< _TT(_A1, _A2, _A3, _A4, ...) > : public iml::detail::true_type {};

	template<typename _TT, typename _A1, typename _A2, typename _A3, typename _A4
		, typename _A5>
	struct function_trait< _TT(_A1, _A2, _A3, _A4, _A5) > : public iml::detail::true_type {};
	template<typename _TT, typename _A1, typename _A2, typename _A3, typename _A4
		, typename _A5>
	struct function_trait< _TT(_A1, _A2, _A3, _A4, _A5, ...) > : public iml::detail::true_type {};

	template<typename _TT, typename _A1, typename _A2, typename _A3, typename _A4
		, typename _A5, typename _A6>
	struct function_trait< _TT(_A1, _A2, _A3, _A4, _A5, _A6) > : public iml::detail::true_type {};
	template<typename _TT, typename _A1, typename _A2, typename _A3, typename _A4
		, typename _A5, typename _A6>
	struct function_trait< _TT(_A1, _A2, _A3, _A4, _A5, _A6, ...) > : public iml::detail::true_type {};

	template<typename _TT, typename _A1, typename _A2, typename _A3, typename _A4
		, typename _A5, typename _A6, typename _A7>
	struct function_trait< _TT(_A1, _A2, _A3, _A4, _A5, _A6, _A7) > : public iml::detail::true_type {};
	template<typename _TT, typename _A1, typename _A2, typename _A3, typename _A4
		, typename _A5, typename _A6, typename _A7>
	struct function_trait< _TT(_A1, _A2, _A3, _A4, _A5, _A6, _A7, ...) > : public iml::detail::true_type {};

	template<typename _TT, typename _A1, typename _A2, typename _A3, typename _A4
		, typename _A5, typename _A6, typename _A7, typename _A8>
	struct function_trait< _TT(_A1, _A2, _A3, _A4, _A5, _A6, _A7, _A8) > : public iml::detail::true_type {};
	template<typename _TT, typename _A1, typename _A2, typename _A3, typename _A4
		, typename _A5, typename _A6, typename _A7, typename _A8>
	struct function_trait< _TT(_A1, _A2, _A3, _A4, _A5, _A6, _A7, _A8, ...) > : public iml::detail::true_type {};

	template<typename _TT, typename _A1, typename _A2, typename _A3, typename _A4
		, typename _A5, typename _A6, typename _A7, typename _A8, typename _A9>
	struct function_trait< _TT(_A1, _A2, _A3, _A4, _A5, _A6, _A7, _A8, _A9) > : public iml::detail::true_type {};
	template<typename _TT, typename _A1, typename _A2, typename _A3, typename _A4
		, typename _A5, typename _A6, typename _A7, typename _A8, typename _A9>
	struct function_trait< _TT(_A1, _A2, _A3, _A4, _A5, _A6, _A7, _A8, _A9, ...) > : public iml::detail::true_type {};

	template<typename _TT, typename _A1, typename _A2, typename _A3, typename _A4
		, typename _A5, typename _A6, typename _A7, typename _A8, typename _A9
		, typename _A10>
	struct function_trait< _TT(_A1, _A2, _A3, _A4, _A5, _A6, _A7, _A8, _A9
		, _A10) > : public iml::detail::true_type {};
	template<typename _TT, typename _A1, typename _A2, typename _A3, typename _A4
		, typename _A5, typename _A6, typename _A7, typename _A8, typename _A9
		, typename _A10>
	struct function_trait< _TT(_A1, _A2, _A3, _A4, _A5, _A6, _A7, _A8, _A9
		, _A10, ...) > : public iml::detail::true_type {};

	template<typename _TT, typename _A1, typename _A2, typename _A3, typename _A4
		, typename _A5, typename _A6, typename _A7, typename _A8, typename _A9
		, typename _A10, typename _A11>
	struct function_trait< _TT(_A1, _A2, _A3, _A4, _A5, _A6, _A7, _A8, _A9
		, _A10, _A11) > : public iml::detail::true_type {};
	template<typename _TT, typename _A1, typename _A2, typename _A3, typename _A4
		, typename _A5, typename _A6, typename _A7, typename _A8, typename _A9
		, typename _A10, typename _A11>
	struct function_trait< _TT(_A1, _A2, _A3, _A4, _A5, _A6, _A7, _A8, _A9
		, _A10, _A11, ...) > : public iml::detail::true_type {};

	template<typename _TT, typename _A1, typename _A2, typename _A3, typename _A4
		, typename _A5, typename _A6, typename _A7, typename _A8, typename _A9
		, typename _A10, typename _A11, typename _A12>
	struct function_trait< _TT(_A1, _A2, _A3, _A4, _A5, _A6, _A7, _A8, _A9
		, _A10, _A11, _A12) > : public iml::detail::true_type {};
	template<typename _TT, typename _A1, typename _A2, typename _A3, typename _A4
		, typename _A5, typename _A6, typename _A7, typename _A8, typename _A9
		, typename _A10, typename _A11, typename _A12>
	struct function_trait< _TT(_A1, _A2, _A3, _A4, _A5, _A6, _A7, _A8, _A9
		, _A10, _A11, _A12, ...) > : public iml::detail::true_type {};

	template<typename _TT, typename _A1, typename _A2, typename _A3, typename _A4
		, typename _A5, typename _A6, typename _A7, typename _A8, typename _A9
		, typename _A10, typename _A11, typename _A12, typename _A13>
	struct function_trait< _TT(_A1, _A2, _A3, _A4, _A5, _A6, _A7, _A8, _A9
		, _A10, _A11, _A12, _A13) > : public iml::detail::true_type {};
	template<typename _TT, typename _A1, typename _A2, typename _A3, typename _A4
		, typename _A5, typename _A6, typename _A7, typename _A8, typename _A9
		, typename _A10, typename _A11, typename _A12, typename _A13>
	struct function_trait< _TT(_A1, _A2, _A3, _A4, _A5, _A6, _A7, _A8, _A9
		, _A10, _A11, _A12, _A13, ...) > : public iml::detail::true_type {};

public:
	enum { value = function_trait<_TN>::value };
};

// detail
namespace detail
{
	template<typename _TT> struct function_traits_helper {};
	template<typename _TT> struct function_traits_helper< _TT (*) (void) > 
	{
		enum { arity = 0 };
		typedef _TT	result_type;
	};
	template<typename _TT, typename _A1>
	struct function_traits_helper< _TT(_A1) >
	{
		enum { arity = 1 };
		typedef _TT	result_type;
		typedef _A1	arg1_type;
	};
	template<typename _TT, typename _A1, typename _A2>
	struct function_traits_helper< _TT(_A1, _A2) >
	{
		enum { arity = 2 };
		typedef _TT	result_type;
		typedef _A1	arg1_type;
		typedef _A2	arg2_type;
	};
	template<typename _TT, typename _A1, typename _A2, typename _A3>
	struct function_traits_helper< _TT(_A1, _A2, _A3) >
	{
		enum { arity = 3 };
		typedef _TT	result_type;
		typedef _A1	arg1_type;
		typedef _A2	arg2_type;
		typedef _A3	arg3_type;
	};
	template<typename _TT, typename _A1, typename _A2, typename _A3, typename _A4>
	struct function_traits_helper< _TT(_A1, _A2, _A3, _A4) >
	{
		enum { arity = 4 };
		typedef _TT	result_type;
		typedef _A1	arg1_type;
		typedef _A2	arg2_type;
		typedef _A3	arg3_type;
		typedef _A4	arg4_type;
	};
	template<typename _TT, typename _A1, typename _A2, typename _A3, typename _A4
		, typename _A5>
	struct function_traits_helper< _TT(_A1, _A2, _A3, _A4, _A5) >
	{
		enum { arity = 5 };
		typedef _TT	result_type;
		typedef _A1	arg1_type;
		typedef _A2	arg2_type;
		typedef _A3	arg3_type;
		typedef _A4	arg4_type;
		typedef _A5	arg5_type;
	};
	template<typename _TT, typename _A1, typename _A2, typename _A3, typename _A4
		, typename _A5, typename _A6>
	struct function_traits_helper< _TT(_A1, _A2, _A3, _A4, _A5, _A6) >
	{
		enum { arity = 6 };
		typedef _TT	result_type;
		typedef _A1	arg1_type;
		typedef _A2	arg2_type;
		typedef _A3	arg3_type;
		typedef _A4	arg4_type;
		typedef _A5	arg5_type;
		typedef _A6	arg6_type;
	};
	template<typename _TT, typename _A1, typename _A2, typename _A3, typename _A4
		, typename _A5, typename _A6, typename _A7>
	struct function_traits_helper< _TT(_A1, _A2, _A3, _A4, _A5, _A6, _A7) >
	{
		enum { arity = 7 };
		typedef _TT	result_type;
		typedef _A1	arg1_type;
		typedef _A2	arg2_type;
		typedef _A3	arg3_type;
		typedef _A4	arg4_type;
		typedef _A5	arg5_type;
		typedef _A6	arg6_type;
		typedef _A7	arg7_type;
	};
	template<typename _TT, typename _A1, typename _A2, typename _A3, typename _A4
		, typename _A5, typename _A6, typename _A7, typename _A8>
	struct function_traits_helper< _TT(_A1, _A2, _A3, _A4, _A5, _A6, _A7, _A8) >
	{
		enum { arity = 8 };
		typedef _TT	result_type;
		typedef _A1	arg1_type;
		typedef _A2	arg2_type;
		typedef _A3	arg3_type;
		typedef _A4	arg4_type;
		typedef _A5	arg5_type;
		typedef _A6	arg6_type;
		typedef _A7	arg7_type;
		typedef _A8	arg8_type;
	};
	template<typename _TT, typename _A1, typename _A2, typename _A3, typename _A4
		, typename _A5, typename _A6, typename _A7, typename _A8, typename _A9>
	struct function_traits_helper< _TT(_A1, _A2, _A3, _A4, _A5, _A6, _A7, _A8, _A9) >
	{
		enum { arity = 9 };
		typedef _TT	result_type;
		typedef _A1	arg1_type;
		typedef _A2	arg2_type;
		typedef _A3	arg3_type;
		typedef _A4	arg4_type;
		typedef _A5	arg5_type;
		typedef _A6	arg6_type;
		typedef _A7	arg7_type;
		typedef _A8	arg8_type;
		typedef _A9	arg9_type;
	};
	template<typename _TT, typename _A1, typename _A2, typename _A3, typename _A4
		, typename _A5, typename _A6, typename _A7, typename _A8, typename _A9
		, typename _A10>
	struct function_traits_helper< _TT(_A1, _A2, _A3, _A4, _A5, _A6, _A7, _A8, _A9
		, _A10) >
	{
		enum { arity = 10 };
		typedef _TT	result_type;
		typedef _A1		arg1_type;
		typedef _A2		arg2_type;
		typedef _A3		arg3_type;
		typedef _A4		arg4_type;
		typedef _A5		arg5_type;
		typedef _A6		arg6_type;
		typedef _A7		arg7_type;
		typedef _A8		arg8_type;
		typedef _A9		arg9_type;
		typedef _A10	arg10_type;
	};
	template<typename _TT, typename _A1, typename _A2, typename _A3, typename _A4
		, typename _A5, typename _A6, typename _A7, typename _A8, typename _A9
		, typename _A10, typename _A11>
	struct function_traits_helper< _TT(_A1, _A2, _A3, _A4, _A5, _A6, _A7, _A8, _A9
		, _A10, _A11) >
	{
		enum { arity = 11 };
		typedef _TT	result_type;
		typedef _A1		arg1_type;
		typedef _A2		arg2_type;
		typedef _A3		arg3_type;
		typedef _A4		arg4_type;
		typedef _A5		arg5_type;
		typedef _A6		arg6_type;
		typedef _A7		arg7_type;
		typedef _A8		arg8_type;
		typedef _A9		arg9_type;
		typedef _A10	arg10_type;
		typedef _A11	arg11_type;
	};
	template<typename _TT, typename _A1, typename _A2, typename _A3, typename _A4
		, typename _A5, typename _A6, typename _A7, typename _A8, typename _A9
		, typename _A10, typename _A11, typename _A12>
	struct function_traits_helper< _TT(_A1, _A2, _A3, _A4, _A5, _A6, _A7, _A8, _A9
		, _A10, _A11, _A12) >
	{
		enum { arity = 12 };
		typedef _TT	result_type;
		typedef _A1		arg1_type;
		typedef _A2		arg2_type;
		typedef _A3		arg3_type;
		typedef _A4		arg4_type;
		typedef _A5		arg5_type;
		typedef _A6		arg6_type;
		typedef _A7		arg7_type;
		typedef _A8		arg8_type;
		typedef _A9		arg9_type;
		typedef _A10	arg10_type;
		typedef _A11	arg11_type;
		typedef _A12	arg12_type;
	};
	template<typename _TT, typename _A1, typename _A2, typename _A3, typename _A4
		, typename _A5, typename _A6, typename _A7, typename _A8, typename _A9
		, typename _A10, typename _A11, typename _A12, typename _A13>
	struct function_traits_helper< _TT(_A1, _A2, _A3, _A4, _A5, _A6, _A7, _A8, _A9
		, _A10, _A11, _A12, _A13) >
	{
		enum { arity = 13 };
		typedef _TT	result_type;
		typedef _A1		arg1_type;
		typedef _A2		arg2_type;
		typedef _A3		arg3_type;
		typedef _A4		arg4_type;
		typedef _A5		arg5_type;
		typedef _A6		arg6_type;
		typedef _A7		arg7_type;
		typedef _A8		arg8_type;
		typedef _A9		arg9_type;
		typedef _A10	arg10_type;
		typedef _A11	arg11_type;
		typedef _A12	arg12_type;
		typedef _A13	arg13_type;
	};
}	// end of namespace detail

/// function traits
template<typename _Function>
class function_traits : public detail::function_traits_helper< _Function >
{
};

}	// end of namespace cpp0x

#endif
