//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		cpp0x_cv_traits.hpp
 * @brief		const volatile t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_cpp0x_cv_traits_HPP_
#define INCG_IRIS_cpp0x_cv_traits_HPP_

//======================================================================
// include
#include "cpp0x_const_traits.hpp"
#include "cpp0x_volatile_traits.hpp"
#include "../../ml/op/iml_op_and.hpp"

namespace cpp0x
{

//======================================================================
// declare
template<typename _TN>class is_cv;		// _TN  const volatileǂ
template<typename _TN>class add_cv;		// _TN  const volatileǉ
template<typename _TN>class remove_cv;	// _TNconst volatile폜

//======================================================================
// class
/// is const volatile trait
template<typename _TN>
class is_cv
{
public:
	enum { value = iml::op_and< is_const<_TN>::value, is_volatile<_TN>::value >::value };
};

/// add const volatile trait
template<typename _TN>
class add_cv
{
public:
	typedef typename add_const< typename add_volatile<_TN>::type >::type	type;
};

/// remove const volatile trait
template<typename _TN>
class remove_cv
{
public:
	typedef typename remove_const< typename remove_volatile<_TN>::type >::type	type;
};

}	// end of namespace cpp0x

#endif
