//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		cpp0x_base_derived_traits.hpp
 * @brief		class t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_cpp0x_base_derived_traits_HPP_
#define INCG_IRIS_cpp0x_base_derived_traits_HPP_

//======================================================================
// include
#include "cpp0x_cv_traits.hpp"
#include "cpp0x_same_traits.hpp"

namespace cpp0x
{

//======================================================================
// declare
template<typename _Base, typename _Derived>class is_base_and_derived;		// p֌Wɂ邩ǂ
template<typename _Base, typename _Derived>class is_base_of;				// p֌Wɂ邩ǂ

//======================================================================
// class
/// is base and derived
template<typename _Base, typename _Derived>
class is_base_and_derived
{
	template<typename B, typename D>
	struct is_bd_helper
	{
#if	defined(_MSC_VER) && (_MSC_VER == 1310)
		static iml::detail::yes_t	check_sig(D const volatile *, long);
		static iml::detail::no_t	check_sig(B const volatile * const&, int);
#else
		template<typename _TT>
		static iml::detail::yes_t	check_sig(D const volatile *, _TT);
		static iml::detail::no_t	check_sig(B const volatile *, int);
#endif
	};

	template<typename B, typename D>
	struct is_bd_base_impl
	{
		struct host
		{
#if	defined(_MSC_VER) && (_MSC_VER == 1310)
			operator B const volatile *const&() const;
#else
			operator B const volatile *() const;
#endif
			operator D const volatile *();
		};
		enum { value = is_iml_yes_t( (is_bd_helper<B, D>::check_sig(host(), 0)) ) };
	};

	template<typename B, typename D>
	struct is_bd_impl_false : public iml::detail::false_type {};

	template<bool ic1, bool ic2, bool iss, typename TMP>struct is_bd_select
	{
		template<class T, class U>struct rebind
		{
			typedef is_bd_impl_false<T, U>	type; 
		};
	};
	template<typename TMP>struct is_bd_select<true, true, false, TMP>
	{
		template<class T, class U>struct rebind
		{
			typedef is_bd_base_impl<T, U>	type; 
		};
	};

	template<typename B, typename D>struct is_base_and_derived_impl
	{
		typedef typename remove_cv<B>::type	ncvB;
		typedef typename remove_cv<D>::type	ncvD;

		typedef is_bd_select<
			  is_class<B>::value
			, is_class<D>::value
			, is_same<B, D>::value
			, void>		selector;
		typedef typename selector::template rebind<ncvB, ncvD>	binder;
		typedef typename binder::type							type;

		enum { value = type::value };
	};

public:
	enum { value = is_base_and_derived_impl<_Base, _Derived>::value };
};

/// is base and derived
template<typename _Base, typename _Derived>
class is_base_of : public is_base_and_derived<_Base, _Derived> {};

}	// end of namespace cpp0x

#endif
