//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		cpp0x_align_traits.hpp
 * @brief		ACg t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_cpp0x_align_traits_HPP_
#define INCG_IRIS_cpp0x_align_traits_HPP_

//======================================================================
// include
#include "../../ml/iml_type_select.hpp"
#include "../../preprocessor/program/PPCat.h"
#include "../../preprocessor/program/arithmetic/PPInc.h"
#include "../../iris_debug.h"

namespace cpp0x
{

//======================================================================
// declare
template<typename _TN>class alignment_of;		// ^̃ACg̎擾
template<int Align>class type_with_alignment;	// w肵ACgTCY̌^

//======================================================================
// class
/// alignment of
template<typename _TN>
class alignment_of
{
	template<typename _TT>struct type_hack
	{
		char	c;
		_TT		t;
	};
	template<unsigned A, unsigned S>struct alignment_logic
	{
		enum { value = A < S ? A : S };
	};
public:
	enum { value = alignment_logic< sizeof(type_hack<_TN>) - sizeof(_TN)
		, sizeof(_TN) >::value };
};
template<typename _TN>
class alignment_of<_TN&> : public alignment_of<_TN> {};

/// is aligned
template<int TAlign, int Align>
struct is_aligned
{
	enum { value = (TAlign >= Align) & (TAlign % Align) };
};

/// alignment of
template<int Align>
class type_with_alignment
{
	class alignment_dummy;
	typedef void *(function_ptr)(void);
	typedef int (alignment_dummy::* member_ptr);
	typedef int (alignment_dummy::* member_function_ptr)(void);

	template<bool found, size_t target, typename _TT>
	struct lower_alignment_helper : public iml::detail::true_type
	{
		typedef char	type;
	};
	template<size_t target, typename _TT>
	struct lower_alignment_helper<false, target, _TT>
	{
		enum { value = (alignment_of<_TT>::value == target) };
		typedef typename iml::type_select<value, _TT, char>::type	type;
	};
	template<size_t target>union lower_alignment
	{
		enum { found0 = false };
#define FIND_TYPE(i, T)		\
	typename lower_alignment_helper<found##i, target, T>::type t##i;	\
	enum { IRIS_PP_CAT(found, IRIS_PP_INC(i)) = lower_alignment_helper<found##i, target, T>::value }

		FIND_TYPE( 0, char);
		FIND_TYPE( 1, short);
		FIND_TYPE( 2, int);
		FIND_TYPE( 3, long);
		FIND_TYPE( 4, long long);
		FIND_TYPE( 5, float);
		FIND_TYPE( 6, double);
		FIND_TYPE( 7, long double);
		FIND_TYPE( 8, void*);
		FIND_TYPE( 9, function_ptr);
		FIND_TYPE(10, member_ptr);
		FIND_TYPE(11, member_function_ptr);
#undef FIND_TYPE
	};

	union max_alignment
	{
		char				t0;
		short				t1;
		int					t2;
		long				t3;
		long long			t4;
		float				t5;
		double				t6;
		long double			t7;
		void*				t8;
		function_ptr		t9;
		member_ptr			t10;
		member_function_ptr	t11;
	};

	typedef lower_alignment<Align>	t1;
	typedef typename iml::type_select< is_aligned< alignment_of<t1>::value, Align >::value
		, t1, max_alignment >::type	align_t;
	enum { found = alignment_of<align_t>::value };

	IRIS_STATIC_ASSERT( found >= Align );
	IRIS_STATIC_ASSERT( found % Align == 0 );
public:
	typedef align_t	type;
};

}	// end of namespace cpp0x

#endif
