//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		cpp0xUnitTest.cpp
 * @brief		P̃eXgt@Ct@C
 *
 * @author		t.sirayanagi
 * @version		1.0
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_cpp0xUnitTest_CPP_

#if	defined(_IRIS_SUPPORT_GOOGLETEST) || defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST)

//======================================================================
// include
#include "../unit/gt/gt_inchead.h"
#include "../unit/UnitCore.h"

#include "cpp0x_static_assert.h"
#include "cpp0x_type_traits.hpp"
#include "cpp0x_regex.hpp"

#include "../iris_debug.h"
#ifdef _IRIS_SUPPORT_RTTI
#include <typeinfo>
#endif

#if	defined(_IRIS_SUPPORT_REGEX)
TEST(Ccpp0xTest, Regex)
{
	cpp0x::tr1::regex reg1("(Colo)(u)(r)", cpp0x::tr1::regex::icase);
	std::string s1 = "Colour, colours, color, colourize, COLOUR";
	std::string s2 = cpp0x::tr1::regex_replace(s1, reg1, "$1$3");
	puts( s2.data() );
}
#endif

#endif

#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST) )

//======================================================================
// class
class Ccpp0xUnitTest : public ::iris::unit::CUnitTest<Ccpp0xUnitTest>
{
public:
	void*	m_pVoid;
	enum eTEST { TEST = 0 };
public:
	/// RXgN^
	Ccpp0xUnitTest(void)		{}
	virtual ~Ccpp0xUnitTest(void)	{}
	void	Func(void);
};

typedef struct tagPOD
{
	int a, b, c;
} POD;

class IAbstract
{
public:
	IAbstract(void)		{}
	~IAbstract(void)	{}

	virtual int	Func(void)	= 0;
};

//======================================================================
// typedef
IRIS_STATIC_ASSERT( !cpp0x::is_pointer<int&>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_pointer<int*>::value );

IRIS_STATIC_ASSERT( !cpp0x::is_reference<int>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_reference<int&>::value );

IRIS_STATIC_ASSERT( !cpp0x::is_const<int>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_const<const int>::value );
IRIS_STATIC_ASSERT( !cpp0x::is_const<const char*>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_const<char* const>::value );

IRIS_STATIC_ASSERT( !cpp0x::is_floating_point<int>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_floating_point<float>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_floating_point<double>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_floating_point<long double>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_floating_point<const volatile float>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_floating_point<const volatile double>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_floating_point<const volatile long double>::value );

IRIS_STATIC_ASSERT(  cpp0x::is_wchar_t<wchar_t>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_wchar_t<const volatile wchar_t>::value );
IRIS_STATIC_ASSERT( !cpp0x::is_wchar_t<char>::value );

IRIS_STATIC_ASSERT(  cpp0x::is_char<char>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_char<const volatile char>::value );
IRIS_STATIC_ASSERT( !cpp0x::is_char<IrisS8>::value );

IRIS_STATIC_ASSERT(  cpp0x::is_s_char<IrisS8>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_s_char<const volatile IrisS8>::value );
IRIS_STATIC_ASSERT( !cpp0x::is_s_char<char>::value );

IRIS_STATIC_ASSERT(  cpp0x::is_u_char<IrisU8>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_u_char<const volatile IrisU8>::value );
IRIS_STATIC_ASSERT( !cpp0x::is_u_char<char>::value );

IRIS_STATIC_ASSERT(  cpp0x::is_char_traits<char>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_char_traits<IrisS8>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_char_traits<IrisU8>::value );
IRIS_STATIC_ASSERT( !cpp0x::is_char_traits<int>::value );

IRIS_STATIC_ASSERT(  cpp0x::is_short<short>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_short<const volatile short>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_short<IrisS16>::value );
IRIS_STATIC_ASSERT( !cpp0x::is_short<IrisU16>::value );

IRIS_STATIC_ASSERT(  cpp0x::is_s_short<IrisS16>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_s_short<const volatile IrisS16>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_s_short<short>::value );
IRIS_STATIC_ASSERT( !cpp0x::is_s_short<IrisU16>::value );

IRIS_STATIC_ASSERT(  cpp0x::is_u_short<IrisU16>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_u_short<const volatile IrisU16>::value );
IRIS_STATIC_ASSERT( !cpp0x::is_u_short<short>::value );

IRIS_STATIC_ASSERT(  cpp0x::is_short_traits<short>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_short_traits<IrisS16>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_short_traits<IrisU16>::value );
IRIS_STATIC_ASSERT( !cpp0x::is_short_traits<int>::value );

IRIS_STATIC_ASSERT(  cpp0x::is_int<int>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_int<const volatile int>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_int<signed int>::value );
IRIS_STATIC_ASSERT( !cpp0x::is_int<IrisS32>::value );

IRIS_STATIC_ASSERT(  cpp0x::is_s_int<signed int>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_s_int<const volatile signed int>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_s_int<int>::value );
IRIS_STATIC_ASSERT( !cpp0x::is_s_int<IrisS32>::value );

IRIS_STATIC_ASSERT(  cpp0x::is_u_int<unsigned int>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_u_int<const volatile unsigned int>::value );
IRIS_STATIC_ASSERT( !cpp0x::is_u_int<IrisU32>::value );

IRIS_STATIC_ASSERT(  cpp0x::is_int_traits<int>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_int_traits<signed int>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_int_traits<unsigned int>::value );
IRIS_STATIC_ASSERT( !cpp0x::is_int_traits<IrisS32>::value );

IRIS_STATIC_ASSERT(  cpp0x::is_long<long>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_long<const volatile long>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_long<signed long>::value );
IRIS_STATIC_ASSERT( !cpp0x::is_long<int>::value );

IRIS_STATIC_ASSERT(  cpp0x::is_s_long<signed long>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_s_long<const volatile signed long>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_s_long<long>::value );
IRIS_STATIC_ASSERT( !cpp0x::is_s_long<int>::value );

IRIS_STATIC_ASSERT(  cpp0x::is_u_long<unsigned long>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_u_long<const volatile unsigned long>::value );
IRIS_STATIC_ASSERT( !cpp0x::is_u_long<int>::value );

IRIS_STATIC_ASSERT(  cpp0x::is_long_traits<long>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_long_traits<signed long>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_long_traits<unsigned long>::value );
IRIS_STATIC_ASSERT( !cpp0x::is_long_traits<int>::value );

IRIS_STATIC_ASSERT(  cpp0x::is_long_long<long long>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_long_long<const volatile long long>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_long_long<signed long long>::value );
IRIS_STATIC_ASSERT( !cpp0x::is_long_long<int>::value );

IRIS_STATIC_ASSERT(  cpp0x::is_s_long_long<signed long long>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_s_long_long<const volatile signed long long>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_s_long_long<long long>::value );
IRIS_STATIC_ASSERT( !cpp0x::is_s_long_long<int>::value );

IRIS_STATIC_ASSERT(  cpp0x::is_u_long_long<unsigned long long>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_u_long_long<const volatile unsigned long long>::value );
IRIS_STATIC_ASSERT( !cpp0x::is_u_long_long<int>::value );

IRIS_STATIC_ASSERT(  cpp0x::is_long_long_traits<long long>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_long_long_traits<signed long long>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_long_long_traits<unsigned long long>::value );
IRIS_STATIC_ASSERT( !cpp0x::is_long_long_traits<int>::value );

IRIS_STATIC_ASSERT( !cpp0x::is_float<int>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_float<float>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_float<const volatile float>::value );

IRIS_STATIC_ASSERT( !cpp0x::is_double<float>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_double<double>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_double<const volatile double>::value );

IRIS_STATIC_ASSERT( !cpp0x::is_long_double<float>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_long_double<long double>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_long_double<const volatile long double>::value );

IRIS_STATIC_ASSERT( !cpp0x::is_floating_point<int>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_floating_point<float>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_floating_point<double>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_floating_point<long double>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_floating_point<const volatile float>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_floating_point<const volatile double>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_floating_point<const volatile long double>::value );

IRIS_STATIC_ASSERT( !cpp0x::is_pointer<int&>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_pointer<int*>::value );

IRIS_STATIC_ASSERT( !cpp0x::is_member_pointer<Ccpp0xUnitTest*>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_member_pointer<int Ccpp0xUnitTest::*>::value );

IRIS_STATIC_ASSERT( !cpp0x::is_reference<int>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_reference<int&>::value );

IRIS_STATIC_ASSERT( !cpp0x::is_const<int>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_const<const int>::value );
IRIS_STATIC_ASSERT( !cpp0x::is_const<const char*>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_const<char* const>::value );

IRIS_STATIC_ASSERT( !cpp0x::is_volatile<int>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_volatile<volatile int>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_volatile<volatile char*>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_volatile<char* volatile>::value );

IRIS_STATIC_ASSERT( !cpp0x::is_array<int>::value );
IRIS_STATIC_ASSERT( !cpp0x::is_array<int*>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_array<int[]>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_array<int[2]>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_array<int[][2]>::value );

IRIS_STATIC_ASSERT( !cpp0x::is_enum<int>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_enum<Ccpp0xUnitTest::eTEST>::value );

IRIS_STATIC_ASSERT( !cpp0x::is_class<int>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_class<Ccpp0xUnitTest>::value );

#ifdef IRIS_HAS_TYPE_TRAITS_INTRINSICS
IRIS_STATIC_ASSERT( !cpp0x::is_empty<int>::value );
IRIS_STATIC_ASSERT( !cpp0x::is_empty<Ccpp0xUnitTest>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_empty< ::iris::IIrisObject>::value );
#endif

IRIS_STATIC_ASSERT( !(cpp0x::is_base_and_derived<Ccpp0xUnitTest, int>::value) );
IRIS_STATIC_ASSERT( !(cpp0x::is_base_and_derived<Ccpp0xUnitTest, ::iris::unit::CUnitTestBase>::value) );
IRIS_STATIC_ASSERT(  (cpp0x::is_base_and_derived< ::iris::unit::CUnitTestBase, Ccpp0xUnitTest >::value) );

#ifdef IRIS_HAS_TYPE_TRAITS_INTRINSICS
IRIS_STATIC_ASSERT( !cpp0x::is_polymorphic<int>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_polymorphic<Ccpp0xUnitTest>::value );
IRIS_STATIC_ASSERT( !cpp0x::is_polymorphic< ::iris::IIrisObject >::value );
#endif

IRIS_STATIC_ASSERT( !cpp0x::is_abstract<Ccpp0xUnitTest>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_abstract<IAbstract>::value );

IRIS_STATIC_ASSERT(  cpp0x::is_function<int Ccpp0xUnitTest::*(int, int, int)>::value );
IRIS_STATIC_ASSERT( !cpp0x::is_function<int (Ccpp0xUnitTest::*)()>::value );

#ifdef IRIS_HAS_TYPE_TRAITS_INTRINSICS
IRIS_STATIC_ASSERT( !cpp0x::is_pod<Ccpp0xUnitTest>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_pod<POD>::value );
#endif

IRIS_STATIC_ASSERT( !cpp0x::is_member_function_pointer<int Ccpp0xUnitTest::*>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_member_function_pointer<int (Ccpp0xUnitTest::*)()>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_member_function_pointer<int (Ccpp0xUnitTest::*)(int, int, int)>::value );

IRIS_STATIC_ASSERT(  (cpp0x::is_same< int, int >::value) );
IRIS_STATIC_ASSERT( !(cpp0x::is_same< int, float >::value) );
IRIS_STATIC_ASSERT(  (cpp0x::is_same< cpp0x::remove_extent<int [2][3][4]>::type, int [3][4] >::value) );
IRIS_STATIC_ASSERT( !(cpp0x::is_same< cpp0x::remove_extent<int [2][3][4]>::type, int [2][3]>::value) );
IRIS_STATIC_ASSERT(  (cpp0x::is_same< cpp0x::remove_all_extent<int [2][3][4]>::type, int >::value) );

IRIS_STATIC_ASSERT( !(cpp0x::is_convertible<Ccpp0xUnitTest, int>::value) );
IRIS_STATIC_ASSERT(  (cpp0x::is_convertible<float, int>::value) );

IRIS_STATIC_ASSERT(  (cpp0x::is_function<int (int, int, int)>::value) );

#ifdef IRIS_HAS_TYPE_TRAITS_INTRINSICS

IRIS_STATIC_ASSERT( !cpp0x::has_trivial_constructor<Ccpp0xUnitTest>::value );
IRIS_STATIC_ASSERT(  cpp0x::has_trivial_constructor<POD>::value );
IRIS_STATIC_ASSERT(  cpp0x::has_trivial_constructor<int>::value );

IRIS_STATIC_ASSERT( !cpp0x::has_trivial_copy<Ccpp0xUnitTest>::value );
IRIS_STATIC_ASSERT(  cpp0x::has_trivial_copy<POD>::value );
IRIS_STATIC_ASSERT(  cpp0x::has_trivial_copy<int>::value );

IRIS_STATIC_ASSERT( !cpp0x::has_trivial_assign<Ccpp0xUnitTest>::value );
IRIS_STATIC_ASSERT(  cpp0x::has_trivial_assign<POD>::value );
IRIS_STATIC_ASSERT(  cpp0x::has_trivial_assign<int>::value );

IRIS_STATIC_ASSERT(  cpp0x::has_trivial_destructor<Ccpp0xUnitTest>::value );
IRIS_STATIC_ASSERT(  cpp0x::has_trivial_destructor<POD>::value );
IRIS_STATIC_ASSERT(  cpp0x::has_trivial_destructor<int>::value );

IRIS_STATIC_ASSERT(  cpp0x::has_virtual_destructor<Ccpp0xUnitTest>::value );

#endif

IRIS_UNITTEST_FIX(Ccpp0xUnitTest, cpp0xUnitTest)
{
	int a = 0;
	int& b = a;
	int* p = &a;
	Ccpp0xUnitTest* pTest = Ccpp0xUnitTest::GetCurrent();
	IRIS_ASSERT( cpp0x::IsPointer(pTest) );
	IRIS_ASSERT( cpp0x::IsPointer(pTest->m_pVoid) );

	{
		IRIS_STATIC_ASSERT( cpp0x::is_scalar<void*>::value );
		IRIS_STATIC_ASSERT( cpp0x::is_scalar<float>::value );
		IRIS_STATIC_ASSERT( cpp0x::is_scalar<volatile const unsigned long long>::value );
		IRIS_STATIC_ASSERT( !cpp0x::is_scalar<Ccpp0xUnitTest>::value );
	}

	{
		IRIS_STATIC_ASSERT( cpp0x::is_char<char>::value );
		IRIS_STATIC_ASSERT( !cpp0x::is_char<signed char>::value );
	}

	{
		iml::type_select< true , unsigned int, int >::type x=0;
		iml::type_select< false, unsigned int, int >::type y=0;
		x = y; y = x;
		const int z = -10;
//		if( x < z ) x = z;	// warning
//		if( y < z ) x = z;	// no warning
	}

	{
		cpp0x::add_pointer<int>::type pa = &a;
		cpp0x::add_pointer<int&>::type pb = &b;
		cpp0x::add_pointer<int*>::type pp = &p;
		cpp0x::remove_pointer<int>::type  ta = a;
		cpp0x::remove_pointer<int*>::type va = a;
		cpp0x::remove_pointer<int&>::type ra = b;
		ta = 10;
		va = 10;
		IRIS_ASSERT( a != 10 );
		ra = 10;
		IRIS_ASSERT( a == 10 );
	}

	{
		int* tp = p;
		cpp0x::add_reference<int>::type ra = a;
		cpp0x::add_reference<int&>::type rb = b;
		cpp0x::add_reference<int*>::type rp = tp;
		cpp0x::remove_reference<int&>::type ta = ra;
		ra = 10;
		IRIS_ASSERT( a == 10 );
		rb = 11;
		IRIS_ASSERT( a == 11 );
		rp = 0;
		IRIS_ASSERT( tp != p );

		ta = 100;
		IRIS_ASSERT( a != 100 );
	}

	{
		cpp0x::remove_const<const int>::type ta = a;
		cpp0x::add_const<int>::type ca = a;
		//ca = -1;	// error
		ta = 11;
	}

	// extent
	{
		printf( "extent int [2][3][4] (0) = %d\n", cpp0x::extent<int [2][3][4], 0>::value );
		printf( "extent int [2][3][4] (1) = %d\n", cpp0x::extent<int [2][3][4], 1>::value );
		printf( "extent int [2][3][4] (2) = %d\n", cpp0x::extent<int [2][3][4], 2>::value );
		printf( "extent int [2][3][4] (3) = %d\n", cpp0x::extent<int [2][3][4], 3>::value );
	}

	// rank
	{
		printf( "rank int = %d\n", cpp0x::rank<int>::value );
		printf( "rank int [2][3][4] = %d\n", cpp0x::rank<int [2][3][4]>::value );
	}

	// alignment_of
	{
		printf( "alignment of \"char\" %d\n"	, cpp0x::alignment_of<char>::value );
		printf( "alignment of \"int\" %d\n"		, cpp0x::alignment_of<int>::value );
		printf( "alignment of \"float\" %d\n"	, cpp0x::alignment_of<float>::value );
		printf( "alignment of \"double\" %d\n"	, cpp0x::alignment_of<double>::value );
		printf( "alignment of \"Ccpp0xUnitTest\" %d\n", cpp0x::alignment_of<Ccpp0xUnitTest>::value );
	}

	// type_with_alignment
	{
		cpp0x::type_with_alignment<4>::type at;
		at.t0 = 0;
	}
}


#endif	// #if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST) )
