//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		AXXABuffer.cpp
 * @brief		XAudio buffer t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_AXXABuffer_CPP_

//======================================================================
// include
#include "AXXABuffer.h"

#if	defined(_IRIS_SUPPORT_XAUDIO2)

namespace iris {
namespace ax {
namespace xaudio
{

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CXABuffer::CXABuffer(void)
{
	Initialize();
}

/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	pFile	= t@CNX
*//***********************************************************************/
CXABuffer::CXABuffer(IAXFile* pFile)
: CAXBuffer(pFile)
{
	Initialize();
}

/**********************************************************************//**
 *
 * 
 *
*//***********************************************************************/
void CXABuffer::Initialize(void)
{
	m_Buffer.PlayBegin	= 0;
	m_Buffer.PlayLength	= 0;
	m_Buffer.LoopBegin	= 0;
	m_Buffer.LoopLength	= 0;
	m_Buffer.Flags		= 0;
	m_Buffer.LoopCount	= XAUDIO2_NO_LOOP_REGION;
}

/**********************************************************************//**
 *
 * Ǎ
 *
 ----------------------------------------------------------------------
 * @param [in]	uSize	= Ǎ݃TCY
 * @return	
*//***********************************************************************/
bool CXABuffer::Read(u32 uSize)
{
	if( !CAXBuffer::Read(uSize) ) return false;
	m_Buffer.AudioBytes = m_ReadSize;
	m_Buffer.pAudioData = static_cast<const BYTE*>(m_pBuffer);
	return true;
}

/**********************************************************************//**
 *
 * Ǎ
 *
 ----------------------------------------------------------------------
 * @param [in]	uSize	= Ǎ݃TCY
 * @return	
*//***********************************************************************/
bool CXABuffer::Read(void)
{
	return CAXBuffer::Read();
}

}	// end of namespace xaudio
}	// end of namespace ax
}	// end of namespace iris

#endif
