//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		AXOggVorbisError.cpp
 * @brief		oggG[t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_AXOggVorbisError_CPP_

#ifdef _IRIS_SUPPORT_OGGVORBIS

//======================================================================
// inculde
#include "AXOggVorbisError.h"
#include "vorbis/vorbisfile.h"

namespace iris {
namespace ax
{

//======================================================================
// define
#define TEXTA(t)	t
#define TEXTW(t)	L##t

#define _SWITCH_ERROR_MESSAGE(func, text)					\
	switch( error )											\
	{														\
	case OV_OK:												\
		func(lpBuf, size, text("OV_OK"));					\
		break;												\
															\
	case OV_FALSE:											\
		func(lpBuf, size, text("OV_FALSE"));				\
		break;												\
	case OV_EOF:											\
		func(lpBuf, size, text("OV_EOF"));					\
		break;												\
	case OV_HOLE:											\
		func(lpBuf, size, text("OV_HOLE"));					\
		break;												\
															\
	case OV_EREAD:											\
		func(lpBuf, size, text("OV_EREAD"));				\
		break;												\
	case OV_EFAULT:											\
		func(lpBuf, size, text("OV_EFAULT"));				\
		break;												\
	case OV_EIMPL:											\
		func(lpBuf, size, text("OV_EIMPL"));				\
		break;												\
	case OV_EINVAL:											\
		func(lpBuf, size, text("OV_EINVAL"));				\
		break;												\
	case OV_ENOTVORBIS:										\
		func(lpBuf, size, text("OV_ENOTVORBIS"));			\
		break;												\
	case OV_EBADHEADER:										\
		func(lpBuf, size, text("OV_EBADHEADER"));			\
		break;												\
	case OV_EVERSION:										\
		func(lpBuf, size, text("OV_EVERSION"));				\
		break;												\
	case OV_ENOTAUDIO:										\
		func(lpBuf, size, text("OV_ENOTAUDIO"));			\
		break;												\
	case OV_EBADPACKET:										\
		func(lpBuf, size, text("OV_EBADPACKET"));			\
		break;												\
	case OV_EBADLINK:										\
		func(lpBuf, size, text("OV_EBADLINK"));				\
		break;												\
	case OV_ENOSEEK:										\
		func(lpBuf, size, text("OV_ENOSEEK"));				\
		break;												\
}

//======================================================================
// function
/**********************************************************************//**
 *
 * G[̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	error	= G[l
 * @param [out]	lpBuf	= o̓obt@
 * @param [in]	size	= o̓obt@TCY
*//***********************************************************************/
void	AXOVFormatMessage (int error, LPTSTR lpBuf, size_t size)
{
#ifdef UNICODE
	AXOVFormatMessageW(error, lpBuf, size);
#else
	AXOVFormatMessageA(error, lpBuf, size);
#endif
}
/**
 * @ref	AXOVFormatMessage
*/
void	AXOVFormatMessageA(int error, LPSTR  lpBuf, size_t size)
{
	if( lpBuf == nullptr ) return;
	_SWITCH_ERROR_MESSAGE(strcpy_s, TEXTA);
}
/**
 * @ref	AXOVFormatMessage
*/
void	AXOVFormatMessageW(int error, LPWSTR lpBuf, size_t size)
{
	if( lpBuf == nullptr ) return;
	_SWITCH_ERROR_MESSAGE(wcscpy_s, TEXTW);
}

}	// end of namespace ax
}	// end of namespace iris

#endif
