//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		AXALDevice.cpp
 * @brief		OpenAL foCX NXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_AXALDevice_CPP_

#ifdef _IRIS_SUPPORT_OPENAL

//======================================================================
// include
#include "AXALDevice.h"

//======================================================================
// link
#ifdef _WIN32
#pragma comment ( lib, "OpenAL32.lib" )
#endif

namespace iris {
namespace ax {
namespace al
{

//======================================================================
// class
// CALDevice

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CALDevice::CALDevice(void)
: m_pDevice(nullptr)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CALDevice::~CALDevice(void)
{
	Close();
}

/**********************************************************************//**
 *
 * 쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	deviceSpecifier	= IvV
 * @return	
*//***********************************************************************/
bool CALDevice::Open(LPCAXALSTR deviceSpecifier)
{
	Close();
	m_pDevice = alcOpenDevice(deviceSpecifier);
	if( m_pDevice == nullptr ) return false;
	return true;
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
bool CALDevice::Close(void)
{
	if( m_pDevice == nullptr ) return false;
	AXALCBOOL ret = alcCloseDevice(m_pDevice);
	m_pDevice = nullptr;
	return (ret != 0);
}

}	// end of namespace al
}	// end of namespace ax
}	// end of namespace iris

#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
#include "../../unit/UnitCore.h"
#include "../../iris_using.h"
#include <stdio.h>

//======================================================================
// test
IRIS_UNITTEST(CAXALDeviceUnitTest, AXALDeviceUnitTest)
{
	CALDevice device;
	if( device.Open(nullptr) )	fprintf(stderr, "ALDevice Open.\n");
	if( device.Close() )		fprintf(stderr, "ALDevice Close.\n");
	if( device.Open("a") )		fprintf(stderr, "ALDevice Open \"a\".\n");
	if( device.Open("") )		fprintf(stderr, "ALDevice Open.\n");
	if( device.Open("") )		fprintf(stderr, "ALDevice Open.\n");
}

#endif	// #if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))

#endif


