//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		AXALBuffer.cpp
 * @brief		OpenAL obt@NXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_AXALBuffer_CPP_

#ifdef _IRIS_SUPPORT_OPENAL

//======================================================================
// include
#include "AXALBuffer.h"
#if		defined(_WIN32)
#include <al.h>
#include <alc.h>
#elif	(defined(TARGET_OS_MAC) && TARGET_OS_MAC)
#include <OpenAL/al.h>
#include <OpenAL/alc.h>
#endif
#include "AXALError.h"

namespace iris {
namespace ax {
namespace al
{

//======================================================================
// typedef
/** @private */
typedef AXALVOID	(AL_APIENTRY *alBufferDataStaticProcPtr)(const AXALS32 bid
															 , AXALENUM format
															 , AXALVOID* data
															 , AXALSIZEI size
															 , AXALSIZEI freq );

//======================================================================
// declare
/** @private */
AXALVOID  alBufferDataStaticProc(const AXALS32 bid, AXALENUM format, AXALVOID* data, AXALSIZEI size, AXALSIZEI freq);

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CALBuffer::CALBuffer(void)
: m_Buffer(0)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CALBuffer::~CALBuffer(void)
{
	Release();
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
bool CALBuffer::Initialize(void)
{
	return Create();
}

/**********************************************************************//**
 *
 * 
 *
*//***********************************************************************/
void CALBuffer::Release(void)
{
	Delete();
}

/**********************************************************************//**
 *
 * obt@̍쐬
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
bool CALBuffer::Create(void)
{
	alGenBuffers(1, &m_Buffer);
	AXAL_DO_CHECK_RESULT(alGetError(), return false);
	if( m_Buffer == 0 ) return false;
	return true;
}

/**********************************************************************//**
 *
 * obt@̍폜
 *
*//***********************************************************************/
void CALBuffer::Delete(void)
{
	alDeleteBuffers(1, &m_Buffer);
}

/**********************************************************************//**
 *
 * g`obt@̓o^
 *
 ----------------------------------------------------------------------
 * @param [in]	pData		= obt@
 * @param [in]	uSize		= obt@TCY
 * @param [in]	nChannel	= `l
 * @param [in]	nFreq		= TvOg
*//***********************************************************************/
void CALBuffer::BindData(LPAXALVOID pData, AXALU32 uSize, AXALS32 nChannel, AXALSIZEI freq)
{
	alBufferData(m_Buffer
		, nChannel == 1 ? AL_FORMAT_MONO16 : AL_FORMAT_STEREO16
		, pData
		, uSize
		, freq );
}

/**********************************************************************//**
 *
 * alobt@Ɋ֘At
 *
 ----------------------------------------------------------------------
 * @param [in]	pData		= obt@
 * @param [in]	uSize		= obt@TCY
 * @param [in]	nChannel	= `l
 * @param [in]	nFreq		= TvOg
*//***********************************************************************/
void CALBuffer::BindDataStatic(LPAXALVOID pData, AXALU32 uSize, AXALS32 nChannel, AXALSIZEI freq)
{
	alBufferDataStaticProc( m_Buffer
		, nChannel == 1 ? AL_FORMAT_MONO16 : AL_FORMAT_STEREO16
		, pData
		, uSize
		, freq );
}

/**********************************************************************//**
 *
 * obt@Lǂ
 *
 ----------------------------------------------------------------------
 * @return ^Ul
*//***********************************************************************/
bool CALBuffer::IsValid(void)	const
{
	return (alIsBuffer(m_Buffer) != 0);
}

/**********************************************************************//**
 *
 * g̎擾
 *
 ----------------------------------------------------------------------
 * @return g
*//***********************************************************************/
AXALS32 CALBuffer::GetFrequency(void)	const
{
	AXALS32 freq;
	geti(AL_FREQUENCY, &freq);
	return freq;
}

/**********************************************************************//**
 *
 * f[^TCY̎擾
 *
 ----------------------------------------------------------------------
 * @return f[^TCY
*//***********************************************************************/
AXALS32 CALBuffer::GetSize(void)	const
{
	AXALS32 size;
	geti(AL_SIZE, &size);
	return size;
}

/**********************************************************************//**
 *
 * 1Tṽrbg̎擾
 *
 ----------------------------------------------------------------------
 * @return  1Tṽrbg
*//***********************************************************************/
AXALS32 CALBuffer::GetBits(void)	const
{
	AXALS32 bits;
	geti(AL_BITS, &bits);
	return bits;
}

/**********************************************************************//**
 *
 * `l̎擾
 *
 ----------------------------------------------------------------------
 * @return `l
*//***********************************************************************/
AXALS32 CALBuffer::GetChannels(void)	const
{
	AXALS32 channels;
	geti(AL_CHANNELS, &channels);
	return channels;
}

// wrap

/**********************************************************************//**
 *
 * alBufferi
 *
 ----------------------------------------------------------------------
 * @param [in]	param	= p[^
 * @param [in]	value	= l
*//***********************************************************************/
void CALBuffer::seti(AXALENUM param, AXALS32 value)
{
	alBufferi(m_Buffer, param, value);
}

/**********************************************************************//**
 *
 * alBufferf
 *
 ----------------------------------------------------------------------
 * @param [in]	param	= p[^
 * @param [in]	value	= l
*//***********************************************************************/
void CALBuffer::setf(AXALENUM param, AXALF32 value)
{
	alBufferf(m_Buffer, param, value);
}

/**********************************************************************//**
 *
 * alBuffer3i
 *
 ----------------------------------------------------------------------
 * @param [in]	param	= p[^
 * @param [in]	v1		= l
 * @param [in]	v2		= l
 * @param [in]	v3		= l
*//***********************************************************************/
void CALBuffer::set3i(AXALENUM param, AXALS32 v1, AXALS32 v2, AXALS32 v3)
{
	alBuffer3i(m_Buffer, param, v1, v2, v3);
}

/**********************************************************************//**
 *
 * alBuffer3f
 *
 ----------------------------------------------------------------------
 * @param [in]	param	= p[^
 * @param [in]	v1		= l
 * @param [in]	v2		= l
 * @param [in]	v3		= l
*//***********************************************************************/
void CALBuffer::set3f(AXALENUM param, AXALF32 v1, AXALF32 v2, AXALF32 v3)
{
	alBuffer3f(m_Buffer, param, v1, v2, v3);
}

/**********************************************************************//**
 *
 * alBufferiv
 *
 ----------------------------------------------------------------------
 * @param [in]	param	= p[^
 * @param [in]	values	= lz
*//***********************************************************************/
void CALBuffer::setiv(AXALENUM param, const AXALS32* values)
{
	alBufferiv(m_Buffer, param, values);
}

/**********************************************************************//**
 *
 * alBufferfv
 *
 ----------------------------------------------------------------------
 * @param [in]	param	= p[^
 * @param [in]	values	= lz
*//***********************************************************************/
void CALBuffer::setfv(AXALENUM param, const AXALF32* values)
{
	alBufferfv(m_Buffer, param, values);
}

/**********************************************************************//**
 *
 * alGetBufferi
 *
 ----------------------------------------------------------------------
 * @param [in]	param	= p[^
 * @param [out]	value	= l
*//***********************************************************************/
void CALBuffer::geti(AXALENUM param, AXALS32* value)	const
{
	alGetBufferi(m_Buffer, param, value);
}

/**********************************************************************//**
 *
 * alGetBufferf
 *
 ----------------------------------------------------------------------
 * @param [in]	param	= p[^
 * @param [out]	value	= l
*//***********************************************************************/
void CALBuffer::getf(AXALENUM param, AXALF32* value)	const
{
	alGetBufferf(m_Buffer, param, value);
}

/**********************************************************************//**
 *
 * alGetBuffer3i
 *
 ----------------------------------------------------------------------
 * @param [in]	param	= p[^
 * @param [out]	v1		= l
 * @param [out]	v1		= l
 * @param [out]	v1		= l
*//***********************************************************************/
void CALBuffer::get3i(AXALENUM param, AXALS32* v1, AXALS32* v2, AXALS32* v3)	const
{
	alGetBuffer3i(m_Buffer, param, v1, v2, v3);
}

/**********************************************************************//**
 *
 * alGetBuffer3f
 *
 ----------------------------------------------------------------------
 * @param [in]	param	= p[^
 * @param [out]	v1		= l
 * @param [out]	v1		= l
 * @param [out]	v1		= l
*//***********************************************************************/
void CALBuffer::get3f(AXALENUM param, AXALF32* v1, AXALF32* v2, AXALF32* v3)	const
{
	alGetBuffer3f(m_Buffer, param, v1, v2, v3);
}

/**********************************************************************//**
 *
 * alGetBufferiv
 *
 ----------------------------------------------------------------------
 * @param [in]	param	= p[^
 * @param [out]	values	= lz
*//***********************************************************************/
void CALBuffer::getiv(AXALENUM param, AXALS32* values)	const
{
	alGetBufferiv(m_Buffer, param, values);
}

/**********************************************************************//**
 *
 * alGetBufferfv
 *
 ----------------------------------------------------------------------
 * @param [in]	param	= p[^
 * @param [out]	values	= lz
*//***********************************************************************/
void CALBuffer::getfv(AXALENUM param, AXALF32* values)	const
{
	alGetBufferfv(m_Buffer, param, values);
}

//======================================================================
// function
/**********************************************************************//**
 * @private
 * @internal
 *
 * alBufferDataStatic
 *
 -----------------------------------------------------------------------
 * @param [in]	bid		= 
 * @param [in]	format	= 
 * @param [in]	data	= 
 * @param [in]	size	= 
 * @param [in]	freq	= 
*//***********************************************************************/
AXALVOID  alBufferDataStaticProc(const AXALS32 bid, AXALENUM format, AXALVOID* data, AXALSIZEI size, AXALSIZEI freq)
{
	static alBufferDataStaticProcPtr proc = nullptr;
	if( proc == nullptr )
		proc = (alBufferDataStaticProcPtr) alcGetProcAddress(nullptr, (const ALCchar*) "alBufferDataStatic");
	if( proc != nullptr )
		proc(bid, format, data, size, freq);
}

}	// end of namespace al
}	// end of namespace ax
}	// end of namespace iris

#endif
