//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		test_xorshift.cpp
 * @brief		test_xorshift t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _FILE_test_xorshift_CPP_

//======================================================================
// include
#include "unit/gt/gt_inchead.h"
#include "math/random/RndXOR.h"
#include "math/random/RndEvaluater.h"
#include "iris_iostream.h"
#include "iris_using.h"

TEST(XorShiftTest, Generate)
{
	CXorShift rnd;
	rnd.SetSeed(0);
	u32 r1 = rnd.GenRand32();
	ASSERT_NE(r1, rnd.GenRand32());
	rnd.SetSeed(1);
	ASSERT_NE(r1, rnd.GenRand32());
	rnd.SetSeed(0);
	ASSERT_EQ(r1, rnd.GenRand32());
}

TEST(XorShiftTest, Chisq)
{
	CXorShift gen;
	CDistribution rnd(&gen);

	std::cout << rnd.Chisq(1) << std::endl;
}

TEST(XorShiftTest, MonoTest)
{
	CXorShift gen;
	CEvaluater eval(&gen);
	int x = 0;
	EXPECT_TRUE( eval.MonoTest(&x) );

	std::cout << x << std::endl;
}
