//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		test_tfpu_vec4.cpp
 * @brief		MathTVector4 eXg t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _FILE_test_tfpu_vec4_CPP_

//======================================================================
// include
#include "unit/gt/gt_inchead.h"
#include "math/tfpu/MathTVector4.h"
#include "iris_using.h"

TEST(MathTVector4Test, Zero)
{
#define ZEROTEST(type, zero)	do {	\
		typedef IrisTVec4<type> vec4;	\
		vec4 vec;						\
		TFpuVec4Zero(&vec);				\
		ASSERT_EQ( zero, vec.x );		\
		ASSERT_EQ( zero, vec.y );		\
		ASSERT_EQ( zero, vec.z );		\
		ASSERT_EQ( zero, vec.w );		\
	} while(0)

	ZEROTEST(int	, 0);
	ZEROTEST(float	, 0.f);
	ZEROTEST(double	, 0.0);
}
