//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		test_tfpu_scalar.cpp
 * @brief		MathTScalar eXg t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _FILE_test_tfpu_scalar_CPP_

//======================================================================
// include
#include "unit/gt/gt_inchead.h"
#include "math/tfpu/MathTScalar.h"
#include "iris_using.h"

TEST(MathTScalarTest, Abs)
{
#define ABSTEST(type, p, m)		do {		\
		ASSERT_EQ( p, TFpuScalarAbs(p) );	\
		ASSERT_EQ( p, TFpuScalarAbs(m) );	\
	} while(0)

	ABSTEST(int		,  100, - 100);
	ABSTEST(float	, 0.5f, -0.5f);
	ABSTEST(double	, 3.33, -3.33);
}

TEST(MathTScalarTest, Acos)
{
#define ACOSTEST(type, zero, v90)		do {	\
		ASSERT_FLOAT_EQ( 90.0f, (float)TFpuScalarAcos(zero) * 180 / 3.14159265358979323846f );	\
		ASSERT_FLOAT_EQ(  0.0f, (float)TFpuScalarAcos(v90) * 180 / 3.14159265358979323846f );	\
	} while(0)

	ACOSTEST(float	, 0.f, 1.f);
	ACOSTEST(double	, 0.0, 1.0);
}

TEST(MathTScalarTest, Asin)
{
#define ASINTEST(type, zero, v90)		do {	\
		ASSERT_FLOAT_EQ(  0.0f, (float)TFpuScalarAsin(zero) * 180 / 3.14159265358979323846f );	\
		ASSERT_FLOAT_EQ( 90.0f, (float)TFpuScalarAsin(v90) * 180 / 3.14159265358979323846f );	\
	} while(0)

	ASINTEST(float	, 0.f, 1.f);
	ASINTEST(double	, 0.0, 1.0);
}
