//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		test_iml_ratio.cpp
 * @brief		iml_ratio.hpp eXg t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _FILE_test_iml_ratio_CPP_

//======================================================================
// include
#include "unit/gt/gt_inchead.h"
#include "c++0x/cpp0x_type_traits.hpp"
#include "ml/ratio/iml_ratio.hpp"
#include "iris_using.h"

TEST(iml_ratioTest, ratio)
{
	ASSERT_EQ(   1, (iml::ratio<2, 200>::num) );
	ASSERT_EQ( 100, (iml::ratio<2, 200>::den) );

	ASSERT_EQ(   1, (iml::ratio<2, 200>::type::num) );
	ASSERT_EQ( 100, (iml::ratio<2, 200>::type::den) );

	ASSERT_EQ(  -1, (iml::ratio<-2, 200>::num) );
	ASSERT_EQ( 100, (iml::ratio<-2, 200>::den) );

	ASSERT_EQ(  -1, (iml::ratio<2, -200>::type::num) );
	ASSERT_EQ( 100, (iml::ratio<2, -200>::type::den) );

	ASSERT_FALSE( (cpp0x::is_same< iml::ratio<2, 200>, iml::ratio<2, 200>::type >::value) );
	ASSERT_TRUE ( (cpp0x::is_same< iml::ratio<1, 100>, iml::ratio<2, 200>::type >::value) );
}

TEST(iml_ratioTest, addition)
{
	{
		typedef iml::ratio< 7, 16>::type ratio1;
		typedef iml::ratio< 5, 12>::type ratio2;
		typedef iml::ratio_addition<ratio1, ratio2>::type ratio12; 
		ASSERT_EQ( 41, ratio12::num );
		ASSERT_EQ( 48, ratio12::den );
	}

	{
		typedef iml::ratio< 7, 16>::type ratio1;
		typedef iml::ratio<-5, 12>::type ratio2;
		typedef iml::ratio_addition<ratio1, ratio2>::type ratio12; 
		ASSERT_EQ(  1, ratio12::num );
		ASSERT_EQ( 48, ratio12::den );
	}
}

TEST(iml_ratioTest, substruct)
{
	{
		typedef iml::ratio< 7, 16>::type ratio1;
		typedef iml::ratio< 5, 12>::type ratio2;
		typedef iml::ratio_substruct<ratio1, ratio2>::type ratio12; 
		ASSERT_EQ(  1, ratio12::num );
		ASSERT_EQ( 48, ratio12::den );
	}

	{
		typedef iml::ratio< 7, 16>::type ratio1;
		typedef iml::ratio<-5, 12>::type ratio2;
		typedef iml::ratio_substruct<ratio1, ratio2>::type ratio12; 
		ASSERT_EQ( 41, ratio12::num );
		ASSERT_EQ( 48, ratio12::den );
	}
}

TEST(iml_ratioTest, multiply)
{
	{
		typedef iml::ratio< 51, 300>::type ratio1;
		typedef iml::ratio< 33, 255>::type ratio2;
		typedef iml::ratio_multiply<ratio1, ratio2>::type ratio12; 
		ASSERT_EQ(  11, ratio12::num );
		ASSERT_EQ( 500, ratio12::den );
	}
	{
		typedef iml::ratio<-51, 300>::type ratio1;
		typedef iml::ratio< 33, 255>::type ratio2;
		typedef iml::ratio_multiply<ratio1, ratio2>::type ratio12; 
		ASSERT_EQ( -11, ratio12::num );
		ASSERT_EQ( 500, ratio12::den );
	}

	{
		typedef iml::ratio<  0, 300>::type ratio1;
		typedef iml::ratio< 33, 255>::type ratio2;
		typedef iml::ratio_multiply<ratio1, ratio2>::type ratio12; 
		ASSERT_EQ( 0, ratio12::num );
		ASSERT_EQ( 1, ratio12::den );
	}
}

TEST(iml_ratioTest, divide)
{
	{
		typedef iml::ratio< 51, 300>::type ratio1;
		typedef iml::ratio<255,  33>::type ratio2;
		typedef iml::ratio_divide<ratio1, ratio2>::type ratio12; 
		ASSERT_EQ(  11, ratio12::num );
		ASSERT_EQ( 500, ratio12::den );
	}

	{
		typedef iml::ratio<-51, 300>::type ratio1;
		typedef iml::ratio<255,  33>::type ratio2;
		typedef iml::ratio_divide<ratio1, ratio2>::type ratio12; 
		ASSERT_EQ( -11, ratio12::num );
		ASSERT_EQ( 500, ratio12::den );
	}
}

TEST(iml_ratioTest, equal)
{
	ASSERT_TRUE ( (iml::ratio_equal< iml::ratio<2, 200>, iml::ratio<2, 200>::type >::value) );
	ASSERT_TRUE ( (iml::ratio_equal< iml::ratio<1, 100>, iml::ratio<2, 200>::type >::value) );
	ASSERT_FALSE( (iml::ratio_equal< iml::ratio<3, 200>, iml::ratio<2, 200>::type >::value) );
}

TEST(iml_ratioTest, not_equal)
{
	ASSERT_FALSE( (iml::ratio_not_equal< iml::ratio<2, 200>, iml::ratio<2, 200>::type >::value) );
	ASSERT_FALSE( (iml::ratio_not_equal< iml::ratio<1, 100>, iml::ratio<2, 200>::type >::value) );
	ASSERT_TRUE ( (iml::ratio_not_equal< iml::ratio<3, 200>, iml::ratio<2, 200>::type >::value) );
}

TEST(iml_ratioTest, less)
{
	ASSERT_TRUE ( (iml::ratio_less< iml::ratio< 0, 5>, iml::ratio<12, 5>::type >::value) );
	ASSERT_TRUE ( (iml::ratio_less< iml::ratio< 1, 5>, iml::ratio<12, 5>::type >::value) );
	ASSERT_TRUE ( (iml::ratio_less< iml::ratio<-8, 5>, iml::ratio<-1, 5>::type >::value) );
	ASSERT_TRUE ( (iml::ratio_less< iml::ratio< 1, 5>, iml::ratio< 2, 5>::type >::value) );
	ASSERT_TRUE ( (iml::ratio_less< iml::ratio<-2, 5>, iml::ratio< 2, 5>::type >::value) );
	ASSERT_TRUE ( (iml::ratio_less< iml::ratio<-2, 5>, iml::ratio<-1, 5>::type >::value) );
	ASSERT_TRUE ( (iml::ratio_less< iml::ratio< 1, 3>, iml::ratio<11, 5>::type >::value) );

	ASSERT_FALSE( (iml::ratio_less< iml::ratio< 2, 5>, iml::ratio< 2, 5>::type >::value) );
	ASSERT_FALSE( (iml::ratio_less< iml::ratio<-2, 5>, iml::ratio<-2, 5>::type >::value) );

	ASSERT_FALSE( (iml::ratio_less< iml::ratio<12, 5>, iml::ratio< 0, 5>::type >::value) );
	ASSERT_FALSE( (iml::ratio_less< iml::ratio<12, 5>, iml::ratio< 1, 5>::type >::value) );
	ASSERT_FALSE( (iml::ratio_less< iml::ratio<-1, 5>, iml::ratio<-9, 5>::type >::value) );
	ASSERT_FALSE( (iml::ratio_less< iml::ratio< 3, 5>, iml::ratio< 2, 5>::type >::value) );
	ASSERT_FALSE( (iml::ratio_less< iml::ratio< 2, 5>, iml::ratio<-2, 5>::type >::value) );
	ASSERT_FALSE( (iml::ratio_less< iml::ratio<-2, 5>, iml::ratio<-3, 5>::type >::value) );
}

TEST(iml_ratioTest, less_equal)
{
	ASSERT_TRUE ( (iml::ratio_less_equal< iml::ratio< 0, 5>, iml::ratio<12, 5>::type >::value) );
	ASSERT_TRUE ( (iml::ratio_less_equal< iml::ratio< 1, 5>, iml::ratio<12, 5>::type >::value) );
	ASSERT_TRUE ( (iml::ratio_less_equal< iml::ratio<-8, 5>, iml::ratio<-1, 5>::type >::value) );
	ASSERT_TRUE ( (iml::ratio_less_equal< iml::ratio< 1, 5>, iml::ratio< 2, 5>::type >::value) );
	ASSERT_TRUE ( (iml::ratio_less_equal< iml::ratio<-2, 5>, iml::ratio< 2, 5>::type >::value) );
	ASSERT_TRUE ( (iml::ratio_less_equal< iml::ratio<-2, 5>, iml::ratio<-1, 5>::type >::value) );
	ASSERT_TRUE ( (iml::ratio_less_equal< iml::ratio< 1, 3>, iml::ratio<11, 5>::type >::value) );

	ASSERT_TRUE ( (iml::ratio_less_equal< iml::ratio< 2, 5>, iml::ratio< 2, 5>::type >::value) );
	ASSERT_TRUE ( (iml::ratio_less_equal< iml::ratio<-2, 5>, iml::ratio<-2, 5>::type >::value) );

	ASSERT_FALSE( (iml::ratio_less_equal< iml::ratio<12, 5>, iml::ratio< 0, 5>::type >::value) );
	ASSERT_FALSE( (iml::ratio_less_equal< iml::ratio<12, 5>, iml::ratio< 1, 5>::type >::value) );
	ASSERT_FALSE( (iml::ratio_less_equal< iml::ratio<-1, 5>, iml::ratio<-9, 5>::type >::value) );
	ASSERT_FALSE( (iml::ratio_less_equal< iml::ratio< 3, 5>, iml::ratio< 2, 5>::type >::value) );
	ASSERT_FALSE( (iml::ratio_less_equal< iml::ratio< 2, 5>, iml::ratio<-2, 5>::type >::value) );
	ASSERT_FALSE( (iml::ratio_less_equal< iml::ratio<-2, 5>, iml::ratio<-3, 5>::type >::value) );
}

TEST(iml_ratioTest, greater)
{
	ASSERT_FALSE( (iml::ratio_greater< iml::ratio< 0, 5>, iml::ratio<12, 5>::type >::value) );
	ASSERT_FALSE( (iml::ratio_greater< iml::ratio< 1, 5>, iml::ratio<12, 5>::type >::value) );
	ASSERT_FALSE( (iml::ratio_greater< iml::ratio<-8, 5>, iml::ratio<-1, 5>::type >::value) );
	ASSERT_FALSE( (iml::ratio_greater< iml::ratio< 1, 5>, iml::ratio< 2, 5>::type >::value) );
	ASSERT_FALSE( (iml::ratio_greater< iml::ratio<-2, 5>, iml::ratio< 2, 5>::type >::value) );
	ASSERT_FALSE( (iml::ratio_greater< iml::ratio<-2, 5>, iml::ratio<-1, 5>::type >::value) );
	ASSERT_FALSE( (iml::ratio_greater< iml::ratio< 1, 3>, iml::ratio<11, 5>::type >::value) );

	ASSERT_FALSE( (iml::ratio_greater< iml::ratio< 2, 5>, iml::ratio< 2, 5>::type >::value) );
	ASSERT_FALSE( (iml::ratio_greater< iml::ratio<-2, 5>, iml::ratio<-2, 5>::type >::value) );

	ASSERT_TRUE ( (iml::ratio_greater< iml::ratio<12, 5>, iml::ratio< 0, 5>::type >::value) );
	ASSERT_TRUE ( (iml::ratio_greater< iml::ratio<12, 5>, iml::ratio< 1, 5>::type >::value) );
	ASSERT_TRUE ( (iml::ratio_greater< iml::ratio<-1, 5>, iml::ratio<-9, 5>::type >::value) );
	ASSERT_TRUE ( (iml::ratio_greater< iml::ratio< 3, 5>, iml::ratio< 2, 5>::type >::value) );
	ASSERT_TRUE ( (iml::ratio_greater< iml::ratio< 2, 5>, iml::ratio<-2, 5>::type >::value) );
	ASSERT_TRUE ( (iml::ratio_greater< iml::ratio<-2, 5>, iml::ratio<-3, 5>::type >::value) );
}

TEST(iml_ratioTest, greater_equal)
{
	ASSERT_FALSE( (iml::ratio_greater_equal< iml::ratio< 0, 5>, iml::ratio<12, 5>::type >::value) );
	ASSERT_FALSE( (iml::ratio_greater_equal< iml::ratio< 1, 5>, iml::ratio<12, 5>::type >::value) );
	ASSERT_FALSE( (iml::ratio_greater_equal< iml::ratio<-8, 5>, iml::ratio<-1, 5>::type >::value) );
	ASSERT_FALSE( (iml::ratio_greater_equal< iml::ratio< 1, 5>, iml::ratio< 2, 5>::type >::value) );
	ASSERT_FALSE( (iml::ratio_greater_equal< iml::ratio<-2, 5>, iml::ratio< 2, 5>::type >::value) );
	ASSERT_FALSE( (iml::ratio_greater_equal< iml::ratio<-2, 5>, iml::ratio<-1, 5>::type >::value) );
	ASSERT_FALSE( (iml::ratio_greater_equal< iml::ratio< 1, 3>, iml::ratio<11, 5>::type >::value) );

	ASSERT_TRUE ( (iml::ratio_greater_equal< iml::ratio< 2, 5>, iml::ratio< 2, 5>::type >::value) );
	ASSERT_TRUE ( (iml::ratio_greater_equal< iml::ratio<-2, 5>, iml::ratio<-2, 5>::type >::value) );

	ASSERT_TRUE ( (iml::ratio_greater_equal< iml::ratio<12, 5>, iml::ratio< 0, 5>::type >::value) );
	ASSERT_TRUE ( (iml::ratio_greater_equal< iml::ratio<12, 5>, iml::ratio< 1, 5>::type >::value) );
	ASSERT_TRUE ( (iml::ratio_greater_equal< iml::ratio<-1, 5>, iml::ratio<-9, 5>::type >::value) );
	ASSERT_TRUE ( (iml::ratio_greater_equal< iml::ratio< 3, 5>, iml::ratio< 2, 5>::type >::value) );
	ASSERT_TRUE ( (iml::ratio_greater_equal< iml::ratio< 2, 5>, iml::ratio<-2, 5>::type >::value) );
	ASSERT_TRUE ( (iml::ratio_greater_equal< iml::ratio<-2, 5>, iml::ratio<-3, 5>::type >::value) );
}

