//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		test_iml_math.cpp
 * @brief		iml_math.hpp eXg t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _FILE_test_iml_math_CPP_

//======================================================================
// include
#include "unit/gt/gt_inchead.h"
#include "ml/iml_math.hpp"
#include "iris_using.h"

TEST(iml_mathTest, gcd)
{
	ASSERT_EQ( -2, (iml::static_gcd<-2, 200>::value) );
	ASSERT_EQ(  2, (iml::static_gcd< 2, 200>::value) );
	ASSERT_EQ(  1, (iml::static_gcd< 5, 17>::value) );
}

TEST(iml_mathTest, lcm)
{
	ASSERT_EQ( 200, (iml::static_lcm<2, 200>::value) );
	ASSERT_EQ( 85, (iml::static_lcm<5, 17>::value) );
}

TEST(iml_mathTest, pow)
{
	ASSERT_EQ(  4, (iml::static_pow<-2, 2>::value) );
	ASSERT_EQ( 16, (iml::static_pow< 2, 4>::value) );
	ASSERT_EQ( 81, (iml::static_pow< 3, 4>::value) );
	ASSERT_EQ(  1, (iml::static_pow< 9, 0>::value) );
	ASSERT_EQ(  0, (iml::static_pow< 0,10>::value) );
}

