//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		test_color.cpp
 * @brief		FndColor eXg t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _FILE_test_color_CPP_

//======================================================================
// include
#include "unit/gt/gt_inchead.h"
#include "fnd/utility/FndBitStream.h"
#include "iris_using.h"

TEST(FndBitStreamTest, Func)
{
	u8 buf[] = { 0x00	// 0b00000000
		, 0x11			// 0b00010001
		, 0xAA			// 0b10101010
		, 0xCD			// 0b11001101
		, 0xFF			// 0b11111111
	};
	CBitStream bs(buf, sizeof(buf));

	ASSERT_EQ( 0x00, bs.getbit(1) );
	ASSERT_EQ( 0x00, bs.getbit(7) );
	ASSERT_EQ( 0x11, bs.getbit(5) );
	ASSERT_EQ( 0x10, bs.getbit(5) );
}

