//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		test_operator.cpp
 * @brief		FndOperator eXg t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _FILE_test_operator_CPP_

//======================================================================
// include
#include "unit/gt/gt_inchead.h"
#include "fnd/container/FndVaugeOperator.h"
#include "iris_using.h"
#include "iris_debug.h"

#include "c++0x/cpp0x_type_traits.hpp"

// FndOperator eXg
// opposite
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeTrueOp, CVaugeFalseOp::opposite>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeFalseOp, CVaugeTrueOp::opposite>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeEqualOp, CVaugeNotEqualOp::opposite>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeLessOp, CVaugeGEqualOp::opposite>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeLEqualOp, CVaugeGreaterOp::opposite>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeGreaterOp, CVaugeLEqualOp::opposite>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeGEqualOp, CVaugeLessOp::opposite>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeNotEqualOp, CVaugeEqualOp::opposite>::value) );

// append
// CVaugeFalseOp
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeFalseOp::append<CVaugeFalseOp>::other, CVaugeFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeFalseOp::append<CVaugeTrueOp>::other, CVaugeTrueOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeFalseOp::append<CVaugeEqualOp>::other, CVaugeEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeFalseOp::append<CVaugeLessOp>::other, CVaugeLessOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeFalseOp::append<CVaugeLEqualOp>::other, CVaugeLEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeFalseOp::append<CVaugeGreaterOp>::other, CVaugeGreaterOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeFalseOp::append<CVaugeGEqualOp>::other, CVaugeGEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeFalseOp::append<CVaugeNotEqualOp>::other, CVaugeNotEqualOp>::value) );

// CVaugeTrueOp
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeTrueOp::append<CVaugeFalseOp>::other, CVaugeFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeTrueOp::append<CVaugeTrueOp>::other, CVaugeTrueOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeTrueOp::append<CVaugeEqualOp>::other, CVaugeEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeTrueOp::append<CVaugeLessOp>::other, CVaugeLessOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeTrueOp::append<CVaugeLEqualOp>::other, CVaugeLEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeTrueOp::append<CVaugeGreaterOp>::other, CVaugeGreaterOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeTrueOp::append<CVaugeGEqualOp>::other, CVaugeGEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeTrueOp::append<CVaugeNotEqualOp>::other, CVaugeNotEqualOp>::value) );

// CVaugeEqualOp
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeEqualOp::append<CVaugeFalseOp>::other, CVaugeFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeEqualOp::append<CVaugeTrueOp>::other, CVaugeTrueOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeEqualOp::append<CVaugeEqualOp>::other, CVaugeEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeEqualOp::append<CVaugeLessOp>::other, CVaugeLEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeEqualOp::append<CVaugeLEqualOp>::other, CVaugeLEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeEqualOp::append<CVaugeGreaterOp>::other, CVaugeGEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeEqualOp::append<CVaugeGEqualOp>::other, CVaugeGEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeEqualOp::append<CVaugeNotEqualOp>::other, CVaugeTrueOp>::value) );

// CVaugeLessOp
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeLessOp::append<CVaugeFalseOp>::other, CVaugeFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeLessOp::append<CVaugeTrueOp>::other, CVaugeTrueOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeLessOp::append<CVaugeEqualOp>::other, CVaugeLEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeLessOp::append<CVaugeLessOp>::other, CVaugeLessOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeLessOp::append<CVaugeLEqualOp>::other, CVaugeLEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeLessOp::append<CVaugeGreaterOp>::other, CVaugeNotEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeLessOp::append<CVaugeGEqualOp>::other, CVaugeTrueOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeLessOp::append<CVaugeNotEqualOp>::other, CVaugeLessOp>::value) );

// CVaugeLEqualOp
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeLEqualOp::append<CVaugeFalseOp>::other, CVaugeFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeLEqualOp::append<CVaugeTrueOp>::other, CVaugeTrueOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeLEqualOp::append<CVaugeEqualOp>::other, CVaugeLEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeLEqualOp::append<CVaugeLessOp>::other, CVaugeLEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeLEqualOp::append<CVaugeLEqualOp>::other, CVaugeLEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeLEqualOp::append<CVaugeGreaterOp>::other, CVaugeTrueOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeLEqualOp::append<CVaugeGEqualOp>::other, CVaugeTrueOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeLEqualOp::append<CVaugeNotEqualOp>::other, CVaugeLessOp>::value) );

// CVaugeGreaterOp
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeGreaterOp::append<CVaugeFalseOp>::other, CVaugeFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeGreaterOp::append<CVaugeTrueOp>::other, CVaugeTrueOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeGreaterOp::append<CVaugeEqualOp>::other, CVaugeGEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeGreaterOp::append<CVaugeLessOp>::other, CVaugeNotEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeGreaterOp::append<CVaugeLEqualOp>::other, CVaugeTrueOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeGreaterOp::append<CVaugeGreaterOp>::other, CVaugeGreaterOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeGreaterOp::append<CVaugeGEqualOp>::other, CVaugeGEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeGreaterOp::append<CVaugeNotEqualOp>::other, CVaugeGreaterOp>::value) );

// CVaugeGEqualOp
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeGEqualOp::append<CVaugeFalseOp>::other, CVaugeFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeGEqualOp::append<CVaugeTrueOp>::other, CVaugeTrueOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeGEqualOp::append<CVaugeEqualOp>::other, CVaugeGEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeGEqualOp::append<CVaugeLessOp>::other, CVaugeTrueOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeGEqualOp::append<CVaugeLEqualOp>::other, CVaugeTrueOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeGEqualOp::append<CVaugeGreaterOp>::other, CVaugeGEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeGEqualOp::append<CVaugeGEqualOp>::other, CVaugeGEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeGEqualOp::append<CVaugeNotEqualOp>::other, CVaugeGreaterOp>::value) );

// CVaugeNotEqualOp
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeNotEqualOp::append<CVaugeFalseOp>::other, CVaugeFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeNotEqualOp::append<CVaugeTrueOp>::other, CVaugeTrueOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeNotEqualOp::append<CVaugeEqualOp>::other, CVaugeTrueOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeNotEqualOp::append<CVaugeLessOp>::other, CVaugeLessOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeNotEqualOp::append<CVaugeLEqualOp>::other, CVaugeLessOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeNotEqualOp::append<CVaugeGreaterOp>::other, CVaugeGreaterOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeNotEqualOp::append<CVaugeGEqualOp>::other, CVaugeGreaterOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeNotEqualOp::append<CVaugeNotEqualOp>::other, CVaugeNotEqualOp>::value) );

// erase
// CVaugeFalseOp
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeFalseOp::erase<CVaugeFalseOp>::other, CVaugeFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeFalseOp::erase<CVaugeTrueOp>::other, CVaugeFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeFalseOp::erase<CVaugeEqualOp>::other, CVaugeFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeFalseOp::erase<CVaugeLessOp>::other, CVaugeFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeFalseOp::erase<CVaugeLEqualOp>::other, CVaugeFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeFalseOp::erase<CVaugeGreaterOp>::other, CVaugeFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeFalseOp::erase<CVaugeGEqualOp>::other, CVaugeFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeFalseOp::erase<CVaugeNotEqualOp>::other, CVaugeFalseOp>::value) );

// CVaugeTrueOp
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeTrueOp::erase<CVaugeFalseOp>::other, CVaugeTrueOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeTrueOp::erase<CVaugeTrueOp>::other, CVaugeFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeTrueOp::erase<CVaugeEqualOp>::other, CVaugeNotEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeTrueOp::erase<CVaugeLessOp>::other, CVaugeGEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeTrueOp::erase<CVaugeLEqualOp>::other, CVaugeGreaterOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeTrueOp::erase<CVaugeGreaterOp>::other, CVaugeLEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeTrueOp::erase<CVaugeGEqualOp>::other, CVaugeLessOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeTrueOp::erase<CVaugeNotEqualOp>::other, CVaugeEqualOp>::value) );

// CVaugeEqualOp
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeEqualOp::erase<CVaugeFalseOp>::other, CVaugeEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeEqualOp::erase<CVaugeTrueOp>::other, CVaugeFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeEqualOp::erase<CVaugeEqualOp>::other, CVaugeFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeEqualOp::erase<CVaugeLessOp>::other, CVaugeEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeEqualOp::erase<CVaugeLEqualOp>::other, CVaugeFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeEqualOp::erase<CVaugeGreaterOp>::other, CVaugeEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeEqualOp::erase<CVaugeGEqualOp>::other, CVaugeFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeEqualOp::erase<CVaugeNotEqualOp>::other, CVaugeEqualOp>::value) );

// CVaugeLessOp
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeLessOp::erase<CVaugeFalseOp>::other, CVaugeLessOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeLessOp::erase<CVaugeTrueOp>::other, CVaugeFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeLessOp::erase<CVaugeEqualOp>::other, CVaugeLessOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeLessOp::erase<CVaugeLessOp>::other, CVaugeFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeLessOp::erase<CVaugeLEqualOp>::other, CVaugeFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeLessOp::erase<CVaugeGreaterOp>::other, CVaugeLessOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeLessOp::erase<CVaugeGEqualOp>::other, CVaugeLessOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeLessOp::erase<CVaugeNotEqualOp>::other, CVaugeLEqualOp>::value) );

// CVaugeLEqualOp
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeLEqualOp::erase<CVaugeFalseOp>::other, CVaugeLEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeLEqualOp::erase<CVaugeTrueOp>::other, CVaugeFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeLEqualOp::erase<CVaugeEqualOp>::other, CVaugeLessOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeLEqualOp::erase<CVaugeLessOp>::other, CVaugeEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeLEqualOp::erase<CVaugeLEqualOp>::other, CVaugeFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeLEqualOp::erase<CVaugeGreaterOp>::other, CVaugeLEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeLEqualOp::erase<CVaugeGEqualOp>::other, CVaugeLEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeLEqualOp::erase<CVaugeNotEqualOp>::other, CVaugeLEqualOp>::value) );

// CVaugeGreaterOp
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeGreaterOp::erase<CVaugeFalseOp>::other, CVaugeGreaterOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeGreaterOp::erase<CVaugeTrueOp>::other, CVaugeFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeGreaterOp::erase<CVaugeEqualOp>::other, CVaugeGreaterOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeGreaterOp::erase<CVaugeLessOp>::other, CVaugeGreaterOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeGreaterOp::erase<CVaugeLEqualOp>::other, CVaugeGreaterOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeGreaterOp::erase<CVaugeGreaterOp>::other, CVaugeFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeGreaterOp::erase<CVaugeGEqualOp>::other, CVaugeFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeGreaterOp::erase<CVaugeNotEqualOp>::other, CVaugeGEqualOp>::value) );

// CVaugeGEqualOp
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeGEqualOp::erase<CVaugeFalseOp>::other, CVaugeGEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeGEqualOp::erase<CVaugeTrueOp>::other, CVaugeFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeGEqualOp::erase<CVaugeEqualOp>::other, CVaugeGreaterOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeGEqualOp::erase<CVaugeLessOp>::other, CVaugeGEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeGEqualOp::erase<CVaugeLEqualOp>::other, CVaugeGEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeGEqualOp::erase<CVaugeGreaterOp>::other, CVaugeEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeGEqualOp::erase<CVaugeGEqualOp>::other, CVaugeFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeGEqualOp::erase<CVaugeNotEqualOp>::other, CVaugeGEqualOp>::value) );

// CVaugeNotEqualOp
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeNotEqualOp::erase<CVaugeFalseOp>::other, CVaugeNotEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeNotEqualOp::erase<CVaugeTrueOp>::other, CVaugeFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeNotEqualOp::erase<CVaugeEqualOp>::other, CVaugeNotEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeNotEqualOp::erase<CVaugeLessOp>::other, CVaugeNotEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeNotEqualOp::erase<CVaugeLEqualOp>::other, CVaugeNotEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeNotEqualOp::erase<CVaugeGreaterOp>::other, CVaugeNotEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeNotEqualOp::erase<CVaugeGEqualOp>::other, CVaugeNotEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeNotEqualOp::erase<CVaugeNotEqualOp>::other, CVaugeFalseOp>::value) );

//======================================================================
// test
TEST(FndVaugeOperatorTest, Func)
{
	// bool
	ASSERT_FALSE( CVaugeFalseOp()(0, 0) );
	ASSERT_FALSE( CVaugeFalseOp()(1, 0) );
	ASSERT_FALSE( CVaugeFalseOp()(0, 1) );

	ASSERT_TRUE(  CVaugeTrueOp()(0, 0) );
	ASSERT_TRUE(  CVaugeTrueOp()(1, 0) );
	ASSERT_TRUE(  CVaugeTrueOp()(0, 1) );

	ASSERT_TRUE ( CVaugeEqualOp()(0, 0) );
	ASSERT_FALSE( CVaugeEqualOp()(1, 0) );
	ASSERT_FALSE( CVaugeEqualOp()(0, 1) );

	ASSERT_FALSE( CVaugeLessOp()(0, 0) );
	ASSERT_FALSE( CVaugeLessOp()(1, 0) );
	ASSERT_TRUE ( CVaugeLessOp()(0, 1) );

	ASSERT_TRUE ( CVaugeLEqualOp()(0, 0) );
	ASSERT_FALSE( CVaugeLEqualOp()(1, 0) );
	ASSERT_TRUE ( CVaugeLEqualOp()(0, 1) );

	ASSERT_FALSE( CVaugeGreaterOp()(0, 0) );
	ASSERT_TRUE ( CVaugeGreaterOp()(1, 0) );
	ASSERT_FALSE( CVaugeGreaterOp()(0, 1) );

	ASSERT_TRUE ( CVaugeGEqualOp()(0, 0) );
	ASSERT_TRUE ( CVaugeGEqualOp()(1, 0) );
	ASSERT_FALSE( CVaugeGEqualOp()(0, 1) );

	ASSERT_FALSE( CVaugeNotEqualOp()(0, 0) );
	ASSERT_TRUE ( CVaugeNotEqualOp()(1, 0) );
	ASSERT_TRUE ( CVaugeNotEqualOp()(0, 1) );

	int vauge = CVaugeGreaterOp()(0, 0);
	if( CVaugeLessOp()(1, 0) )
	{
		ASSERT_TRUE(false);
	}

	// vauge
	ASSERT_EQ( IrisVaugeBool::VB_FALSE, CVaugeFalseOp()(0, 0) );
	ASSERT_EQ( IrisVaugeBool::VB_FALSE, CVaugeFalseOp()(1, 0) );
	ASSERT_EQ( IrisVaugeBool::VB_FALSE, CVaugeFalseOp()(0, 1) );

	ASSERT_EQ( IrisVaugeBool::VB_TRUE , CVaugeTrueOp()(0, 0) );
	ASSERT_EQ( IrisVaugeBool::VB_TRUE , CVaugeTrueOp()(1, 0) );
	ASSERT_EQ( IrisVaugeBool::VB_TRUE , CVaugeTrueOp()(0, 1) );

	ASSERT_EQ( IrisVaugeBool::VB_TRUE , CVaugeEqualOp()(0, 0) );
	ASSERT_EQ( IrisVaugeBool::VB_FALSE, CVaugeEqualOp()(1, 0) );
	ASSERT_EQ( IrisVaugeBool::VB_FALSE, CVaugeEqualOp()(0, 1) );

	ASSERT_EQ( IrisVaugeBool::VB_VAUGE, CVaugeLessOp()(0, 0) );
	ASSERT_EQ( IrisVaugeBool::VB_FALSE, CVaugeLessOp()(1, 0) );
	ASSERT_EQ( IrisVaugeBool::VB_TRUE , CVaugeLessOp()(0, 1) );

	ASSERT_EQ( IrisVaugeBool::VB_TRUE , CVaugeLEqualOp()(0, 0) );
	ASSERT_EQ( IrisVaugeBool::VB_FALSE, CVaugeLEqualOp()(1, 0) );
	ASSERT_EQ( IrisVaugeBool::VB_TRUE , CVaugeLEqualOp()(0, 1) );

	ASSERT_EQ( IrisVaugeBool::VB_VAUGE, CVaugeGreaterOp()(0, 0) );
	ASSERT_EQ( IrisVaugeBool::VB_TRUE , CVaugeGreaterOp()(1, 0) );
	ASSERT_EQ( IrisVaugeBool::VB_FALSE, CVaugeGreaterOp()(0, 1) );

	ASSERT_EQ( IrisVaugeBool::VB_TRUE , CVaugeGEqualOp()(0, 0) );
	ASSERT_EQ( IrisVaugeBool::VB_TRUE , CVaugeGEqualOp()(1, 0) );
	ASSERT_EQ( IrisVaugeBool::VB_FALSE, CVaugeGEqualOp()(0, 1) );

	ASSERT_EQ( IrisVaugeBool::VB_FALSE, CVaugeNotEqualOp()(0, 0) );
	ASSERT_EQ( IrisVaugeBool::VB_TRUE , CVaugeNotEqualOp()(1, 0) );
	ASSERT_EQ( IrisVaugeBool::VB_TRUE , CVaugeNotEqualOp()(0, 1) );
}

