//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		test_refptr.cpp
 * @brief		FndRefPtr eXg t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _FILE_test_refptr_CPP_

//======================================================================
// include
#include "unit/gt/gt_inchead.h"
#include "fnd/container/FndRefPtr.h"
#include "iris_using.h"

typedef CRefPtr<int>	RefPtr;

#if	defined(IRIS_MSC)
#  ifndef _DEBUG_NEW_
#    define _DEBUG_NEW_		new ( _NORMAL_BLOCK , __FILE__, __LINE__)
#    pragma push_macro("new")
#    define new _DEBUG_NEW_
#  endif
#endif

TEST(FndRefPtrTest, Func)
{
	int* p = new int (100);
	RefPtr mstr = p;

	{
		RefPtr	rp1 = mstr;
		RefPtr	rp2 = rp1;
		ASSERT_TRUE( rp1.is_valid() );
		ASSERT_TRUE( rp2.is_valid() );
		ASSERT_TRUE( mstr.is_valid() );
		ASSERT_EQ( 100, *rp1 );
		*rp2 = 1;
	}
	ASSERT_TRUE( mstr.is_valid() );
	ASSERT_EQ( 1, *mstr );
}
