//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		test_ieee.cpp
 * @brief		FndIEEE eXg t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _FILE_test_ieee_CPP_

//======================================================================
// include
#include "unit/gt/gt_inchead.h"
#include "fnd/types/FndIEEE.h"
#include "iris_using.h"

TEST(FndIEEETest, constValue)
{
	CIEEE754<u16, 1, 5, 10> ieee;
	CIEEE754<u16, 0, 6, 10> ieee2;

	ASSERT_EQ( 0x7C00, ieee.PINF );
	ASSERT_EQ( 0xFC00, ieee.NINF );

	ASSERT_EQ( 0xFC00, ieee2.PINF );
	ASSERT_EQ( 0xFC00, ieee2.NINF );

	ASSERT_EQ( MATH_F32_P_INF_BITS, CIEEEBinary32::PINF );
	ASSERT_EQ( MATH_F32_N_INF_BITS, CIEEEBinary32::NINF );
}

TEST(FndIEEETest, cast)
{
	CIEEE754<u16, 1, 5, 10> ieee;
	CIEEE754<u16, 0, 6, 10> ieee2;
	ieee = 2.5f;

	ASSERT_EQ( 0x4100, ieee.value() );
	ASSERT_FLOAT_EQ( 2.5f, (float)ieee );

	ieee2 = ieee;
	ASSERT_EQ( 0x8100, ieee2.value() );
	ASSERT_FLOAT_EQ( 2.5f, (float)ieee2 );
}
