//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		test_typetraits.cpp
 * @brief		typetraits eXg t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _FILE_test_typetraits_CPP_

//======================================================================
// include
#include "unit/gt/gt_inchead.h"
#include "c++0x/cpp0x_type_traits.hpp"
#include "iris_using.h"

#define IS_TRAITES_TEXT( _name, _type, _result)						\
	ASSERT_##_result( cpp0x::_name<_type>::value );					\
	ASSERT_##_result( cpp0x::_name<const _type>::value );			\
	ASSERT_##_result( cpp0x::_name<volatile _type>::value );		\
	ASSERT_##_result( cpp0x::_name<volatile const _type>::value );	\
	ASSERT_##_result( cpp0x::_name<far _type>::value );				\
	ASSERT_##_result( cpp0x::_name<near _type>::value );			\
	ASSERT_##_result( cpp0x::_name<register _type>::value )			\

TEST(TypeTraitsTest, is_pointer)
{
	IS_TRAITES_TEXT(is_pointer, int , FALSE);
	IS_TRAITES_TEXT(is_pointer, int*, TRUE);
	IS_TRAITES_TEXT(is_pointer, int&, FALSE);
}

TEST(TypeTraitsTest, is_reference)
{
	IS_TRAITES_TEXT(is_reference, int , FALSE);
	IS_TRAITES_TEXT(is_reference, int*, FALSE);
	IS_TRAITES_TEXT(is_reference, int&, TRUE);
}

TEST(TypeTraitsTest, is_floating_point)
{
	IS_TRAITES_TEXT(is_floating_point, int , FALSE);
	IS_TRAITES_TEXT(is_floating_point, int*, FALSE);
	IS_TRAITES_TEXT(is_floating_point, int&, FALSE);
	IS_TRAITES_TEXT(is_floating_point, f32 , TRUE);
	IS_TRAITES_TEXT(is_floating_point, f32&, FALSE);
	IS_TRAITES_TEXT(is_floating_point, f32*, FALSE);
	IS_TRAITES_TEXT(is_floating_point, f64 , TRUE);
	IS_TRAITES_TEXT(is_floating_point, f64&, FALSE);
	IS_TRAITES_TEXT(is_floating_point, f64*, FALSE);
	IS_TRAITES_TEXT(is_floating_point, long double , TRUE);
	IS_TRAITES_TEXT(is_floating_point, long double&, FALSE);
	IS_TRAITES_TEXT(is_floating_point, long double*, FALSE);
}

TEST(TypeTraitsTest, is_char)
{
	IS_TRAITES_TEXT(is_char, char , TRUE);
	IS_TRAITES_TEXT(is_char, c8   , TRUE);
	IS_TRAITES_TEXT(is_char, s8   , FALSE);
	IS_TRAITES_TEXT(is_char, u8   , FALSE);
}

TEST(TypeTraitsTest, is_s_char)
{
	IS_TRAITES_TEXT(is_s_char, signed char , TRUE);
	IS_TRAITES_TEXT(is_s_char, c8   , FALSE);
	IS_TRAITES_TEXT(is_s_char, s8   , TRUE);
	IS_TRAITES_TEXT(is_s_char, u8   , FALSE);
}

TEST(TypeTraitsTest, is_u_char)
{
	IS_TRAITES_TEXT(is_u_char, unsigned char , TRUE);
	IS_TRAITES_TEXT(is_u_char, c8   , FALSE);
	IS_TRAITES_TEXT(is_u_char, s8   , FALSE);
	IS_TRAITES_TEXT(is_u_char, u8   , TRUE);
}

TEST(TypeTraitsTest, is_char_traits)
{
	IS_TRAITES_TEXT(is_char_traits, char , TRUE);
	IS_TRAITES_TEXT(is_char_traits, c8   , TRUE);
	IS_TRAITES_TEXT(is_char_traits, s8   , TRUE);
	IS_TRAITES_TEXT(is_char_traits, u8   , TRUE);
}


TEST(IceTest, static_if)
{
}