@echo off
call _setenv.bat
pushd %~dp0

cd /d %CVINSTALLDIR%
if errorlevel 1 goto error

SET OPTION=-D BUILD_DOXYGEN_DOCS=OFF -D BUILD_PYTHON_SUPPORT=ON -D ENABLE_OPENMP=OFF -D BUILD_SHARED_LIBS=OFF -D BUILD_TESTS=OFF
SET PATH=%windir%\Microsoft.NET\Framework\v2.0.50727;%PATH%
SET VCNUM=2005
SET VCDIR=msvc8
SET RUNTIMELIB=mt
SET WORKSPACE=build\static_mt\%VCDIR%
SET GENRATOR="Visual Studio 8 2005"
SET Cxx_FLAGS_DEBUG=-D CMAKE_C_FLAGS_DEBUG="/MTd" -D CMAKE_CXX_FLAGS_DEBUG="/MTd"
SET Cxx_FLAGS_RELEASE=-D CMAKE_C_FLAGS_RELEASE="/MT" -D CMAKE_CXX_FLAGS_RELEASE="/MT"

rem CMake
if not exist %WORKSPACE%\OpenCV.sln (
	if not exist build				mkdir build
	if not exist build\static_mt	mkdir build\static_mt

	if not exist %WORKSPACE%	mkdir %WORKSPACE%
	cd %WORKSPACE%
	cmake -G %GENRATOR% %OPTION% -D CMAKE_BUILD_TYPE=DEBUG %Cxx_FLAGS_DEBUG% -D CMAKE_EXE_LINKER_FLAGS="/NODEFAULTLIB:MSVCRTD.lib"  ../../../
	cmake -G %GENRATOR% %OPTION% -D CMAKE_BUILD_TYPE=RELEASE %Cxx_FLAGS_RELEASE% -D CMAKE_EXE_LINKER_FLAGS="/NODEFAULTLIB:MSVCRT.lib"  ../../../
) else (
	cd %WORKSPACE%
)

rem Debug
msbuild /p:Configuration=Debug /p:Platform=Win32		/t:Build OpenCV.sln
rem if errorlevel 1 goto error

rem Release
msbuild /p:Configuration=Release /p:Platform=Win32		/t:Build OpenCV.sln
rem if errorlevel 1 goto error

:filesync
cd /d "%~dp0"
call filesync_static.bat

goto end

:error
pause

:end
popd


