// ========================================================================================
//	EARTH_PT3.h
//	o[W 3.0 (2013.10.15)
// ========================================================================================

#ifndef _EARTH_PT3_H
#define _EARTH_PT3_H

#include "Prefix.h"

namespace EARTH {
namespace PT {
	class Device;
	class Device_;

	// +------------+
	// | oXNX |
	// +------------+
	// oX̃foCX񋓂܂B܂foCXCX^X𐶐܂B
	class Bus {
	public:
		// [@\] Bus CX^X𐶐
		// [] pΏۃhCo "windrvr6_EARTHSOFT_PT3" łB
		// [Ԓl] STATUS_INVALID_PARAM_ERROR   bus  NULL
		//        STATUS_WDAPI_LOAD_ERROR     LoadLibrary(TEXT("wdapi####.dll")) ̕Ԓl NULL [#### ̓o[Wԍ]
		//        STATUS_WD_DriverName_ERROR  WD_DriverName() ̕Ԓl NULL
		//        STATUS_WD_Open_ERROR        WD_Open() ŃG[
		//        STATUS_WD_Version_ERROR     WD_Version() ŃG[B܂̓o[W 11.1.0 łȂ
		//        STATUS_WD_License_ERROR     WD_License() ŃG[
		typedef status (*NewBusFunction)(Bus **bus);

		// [@\] CX^X
		// [] delete ͎g܂B̊֐ĂяoĂB
		// [Ԓl] STATUS_ALL_DEVICES_MUST_BE_DELETED_ERROR  NewDevice() ŐꂽfoCXS Delete() ĂȂ
		virtual status Delete() = 0;

		// [@\] SDK o[W擾
		// [] o[W 2.0 ̏ꍇAl 0x200 ɂȂ܂B
		//         24 rbgł΃oCi݊ɂȂ悤ɓw߂܂̂ŁA
		//        ((version >> 8) == 2) ł邩`FbNĂB
		// [Ԓl] STATUS_INVALID_PARAM_ERROR   version  NULL
		virtual status GetVersion(uint32 *version) const = 0;

		// foCX
		struct DeviceInfo {
			uint32	Bus;		// PCI oXԍ
			uint32	Slot;		// PCI foCXԍ
			uint32	Function;	// PCI t@NVԍ (퓮쎞͕K 0 ɂȂ܂)
			uint32	PTn;		// i (PT3:3)
		};

		// [@\] FĂfoCX̃Xg擾
		// [] PCI oXXLăfoCXXgAbv܂B
		//        deviceInfoCount ͌ĂяoOɃfoCX̏w肵܂Bďo͌foCXԂ܂B
		// [Ԓl] STATUS_INVALID_PARAM_ERROR     deviceInfoPtr, deviceInfoCount ̂ꂩ NULL
		//        STATUS_WD_PciScanCards_ERROR  WD_PciScanCards ŃG[
		virtual status Scan(DeviceInfo *deviceInfoPtr, uint32 *deviceInfoCount) = 0;

		// [@\] foCXCX^X𐶐
		// [] foCX\[X̔r`FbN͂̊֐ł͍s܂BDevice::Open() ōs܂B
		//        Device_ ͔JC^[tF[XłBdevice_  NULL ɂĂB
		// [Ԓl] STATUS_INVALID_PARAM_ERROR   deviceInfoPtr, device ̂ꂩ NULL
		//                                      ܂͈ _device  NULL łȂ
		virtual status NewDevice(const DeviceInfo *deviceInfoPtr, Device **device, Device_ **device_ = NULL) = 0;

	protected:
		virtual ~Bus() {}
	};

	// +----------------+
	// | foCXNX |
	// +----------------+
	// ̃CX^X 1 {[h 1 ɑΉĂ܂B
	class Device {
	public:
		// ----
		// 
		// ----

		// [@\] CX^X
		// [] delete ͎g܂B̊֐ĂяoĂB
		// [Ԓl] STATUS_DEVICE_MUST_BE_CLOSED_ERROR  foCXI[vԂȂ̂ŃCX^XłȂ
		virtual status Delete() = 0;
		
		// ------------------
		// I[vEN[Y
		// ------------------

		// [@\] foCX̃I[v
		// [] ȉ̎菇ɉčs܂B
		//        1. ɃfoCXI[vĂȂmFB
		//        2. rWID (RtBM[V AhX 0x08)  0x01 ł邩𒲂ׂB
		//        3. RtBM[VԂ̃foCXŗLWX^̈g PCI oXł̃rbgȂmFB
		//        4.  SDK Ő䂪\ FPGA H̃o[Wł邩mFB
		// [Ԓl] STATUS_DEVICE_IS_ALREADY_OPEN_ERROR    foCX͊ɃI[vĂ
		//        STATUS_WD_PciGetCardInfo_ERROR         WD_PciGetCardInfo() ŃG[
		//        STATUS_WD_PciGetCardInfo_Bus_ERROR     oX񐔂 1 ȊO
		//        STATUS_WD_PciGetCardInfo_Memory_ERROR  񐔂 1 ȊO
		//        STATUS_WD_CardRegister_ERROR           WD_CardRegister() ŃG[
		//        STATUS_WD_PciConfigDump_ERROR          WD_PciConfigDump() ŃG[
		//        STATUS_CONFIG_REVISION_ERROR           rWID  0x01 łȂ
		//        STATUS_PCI_BUS_ERROR                   PCI oXł̃rbg
		//        STATUS_PCI_BASE_ADDRESS_ERROR          RtBM[VԂ BaseAddress0  0
		//        STATUS_FPGA_VERSION_ERROR              ΉĂȂ FPGA Ho[W
		//        STATUS_WD_CardCleanupSetup_ERROR       WD_CardCleanupSetup() ŃG[
		//        STATUS_DCM_LOCK_TIMEOUT_ERROR          DCM 莞ԌoߌbNԂɂȂȂ
		//        STATUS_DCM_SHIFT_TIMEOUT_ERROR         DCM ̃tF[YVtg莞ԌoߌȂ
		virtual status Open() = 0;

		// [@\] foCX̃N[Y
		// [Ԓl] STATUS_DEVICE_IS_NOT_OPEN_ERROR  foCXI[vĂȂ
		virtual status Close() = 0;

		// ------------
		// Œ擾
		// ------------
		struct ConstantInfo {
			uint8	PTn;							// WX^ 0x00 [31:24]
			uint8	Version_RegisterMap;			// WX^ 0x00 [23:16]
			uint8	Version_FPGA;					// WX^ 0x00 [15: 8]
			bool	CanTransportTS;					// WX^ 0x0c [ 5]
			uint32	BitLength_PageDescriptorSize;	// WX^ 0x0c [ 4: 0]
		};

		virtual status GetConstantInfo(ConstantInfo *) const = 0;

		// ------------
		// dE
		// ------------

		enum LnbPower {
			LNB_POWER_OFF,	// It
			LNB_POWER_15V,	// 15V o
			LNB_POWER_11V	// 11V o
		};

		// [@\] LNB d
		// [] `[i[̓dƂ͓Ɨɐ\łBftHgl LNB_POWER_OFF łB
		// [Ԓl] STATUS_DEVICE_IS_NOT_OPEN_ERROR  foCXI[vĂȂ
		//        STATUS_INVALID_PARAM_ERROR        lnbPower  NULL (GetLnbPower ̂)
		virtual status SetLnbPower(LnbPower  lnbPower)       = 0;
		virtual status GetLnbPower(LnbPower *lnbPower) const = 0;

		// [@\] foCXN[YiُIɂƂȂN[Y܂ށj LNB d
		// [] ftHgl LNB_POWER_OFF łB
		// [Ԓl] STATUS_INVALID_PARAM_ERROR   lnbPower  NULL (GetLnbPowerWhenClose ̂)
		// [ύX] o[W 3.0 炱̊֐̓삪ύX܂B
		//        LNB_POWER_15V ܂ LNB_POWER_11V ɐݒ肷ꍇ́A
		//        Open() ̑O SetLnbPowerWhenClose() R[܂B
		virtual status SetLnbPowerWhenClose(LnbPower  lnbPower)       = 0;
		virtual status GetLnbPowerWhenClose(LnbPower *lnbPower) const = 0;

		// [@\] `[i[
		// [] `[i[܂B
		// [Ԓl] STATUS_DEVICE_IS_NOT_OPEN_ERROR  foCXI[vĂȂ
		//        STATUS_I2C_ERROR                 IC 烊[hWX^lُ
		virtual status InitTuner() = 0;

		// M
		enum ISDB {
			ISDB_S,
			ISDB_T,

			ISDB_COUNT
		};

		// [@\] `[i[ȓd͐
		// [] `[i[͏ȓd̓IɂȂĂ܂̂ŁAMOɏȓd͂ItɂKv܂B
		// [Ԓl] STATUS_DEVICE_IS_NOT_OPEN_ERROR  foCXI[vĂȂ
		//        STATUS_INVALID_PARAM_ERROR        tuner  1 傫 isdb ͈͊O
		//                                            sleep  NULL (GetTunerSleep ̂)
		virtual status SetTunerSleep(ISDB isdb, uint32 index, bool  sleep)       = 0;
		virtual status GetTunerSleep(ISDB isdb, uint32 index, bool *sleep) const = 0;

		// ----------
		// ǔg
		// ----------

		// [@\] ǔg̐
		// [] offset Ŏg̒\łBPʂ ISDB-S ̏ꍇ 1kHzAISDB-T ̏ꍇ 1/7MHz łB
		//        Ⴆ΁AC24 W 2MHz gɐݒ肷ɂ SetFrequency(tuner, ISDB_T, 23, 7*2) Ƃ܂B
		// [Ԓl] STATUS_DEVICE_IS_NOT_OPEN_ERROR  foCXI[vĂȂ
		//        STATUS_INVALID_PARAM_ERROR        tuner  1 傫 isdb ͈͊O
		//                                            channel  NULL (GetFrequency ̂)
		//        STATUS_TUNER_IS_SLEEP_ERROR      `[i[ȓd͏Ԃ̂ߐݒs (SetFrequency ̂)
		virtual status SetFrequency(ISDB isdb, uint32 index, uint32  channel, sint32  offset = 0)       = 0;
		virtual status GetFrequency(ISDB isdb, uint32 index, uint32 *channel, sint32 *offset = 0) const = 0;

		// (ISDB-S)
		// +----+------+---------+ +----+------+---------+ +----+------+---------+
		// | ch | TP # | f (MHz) | | ch | TP # | f (MHz) | | ch | TP # | f (MHz) |
		// +----+------+---------+ +----+------+---------+ +----+------+---------+
		// |  0 | BS 1 | 1049.48 | | 12 | ND 2 | 1613.00 | | 24 | ND 1 | 1593.00 |
		// |  1 | BS 3 | 1087.84 | | 13 | ND 4 | 1653.00 | | 25 | ND 3 | 1633.00 |
		// |  2 | BS 5 | 1126.20 | | 14 | ND 6 | 1693.00 | | 26 | ND 5 | 1673.00 |
		// |  3 | BS 7 | 1164.56 | | 15 | ND 8 | 1733.00 | | 27 | ND 7 | 1713.00 |
		// |  4 | BS 9 | 1202.92 | | 16 | ND10 | 1773.00 | | 28 | ND 9 | 1753.00 |
		// |  5 | BS11 | 1241.28 | | 17 | ND12 | 1813.00 | | 29 | ND11 | 1793.00 |
		// |  6 | BS13 | 1279.64 | | 18 | ND14 | 1853.00 | | 30 | ND13 | 1833.00 |
		// |  7 | BS15 | 1318.00 | | 19 | ND16 | 1893.00 | | 31 | ND15 | 1873.00 |
		// |  8 | BS17 | 1356.36 | | 20 | ND18 | 1933.00 | | 32 | ND17 | 1913.00 |
		// |  9 | BS19 | 1394.72 | | 21 | ND20 | 1973.00 | | 33 | ND19 | 1953.00 |
		// | 10 | BS21 | 1433.08 | | 22 | ND22 | 2013.00 | | 34 | ND21 | 1993.00 |
		// | 11 | BS23 | 1471.44 | | 23 | ND24 | 2053.00 | | 35 | ND23 | 2033.00 |
		// +----+------+---------+ +----+------+---------+ +----+------+---------+
		// 
		// (ISDB-T)
		// +-----+-----+---------+ +-----+-----+---------+ +-----+-----+---------+ +-----+-----+---------+ +-----+-----+---------+
		// | ch. | Ch. | f (MHz) | | ch. | Ch. | f (MHz) | | ch. | Ch. | f (MHz) | | ch. | Ch. | f (MHz) | | ch. | Ch. | f (MHz) |
		// +-----+-----+---------+ +-----+-----+---------+ +-----+-----+---------+ +-----+-----+---------+ +-----+-----+---------+
		// |   0 |   1 |  93+1/7 | |  23 | C24 | 231+1/7 | |  46 | C47 | 369+1/7 | |  69 |  19 | 509+1/7 | |  92 |  42 | 647+1/7 |
		// |   1 |   2 |  99+1/7 | |  24 | C25 | 237+1/7 | |  47 | C48 | 375+1/7 | |  70 |  20 | 515+1/7 | |  93 |  43 | 653+1/7 |
		// |   2 |   3 | 105+1/7 | |  25 | C26 | 243+1/7 | |  48 | C49 | 381+1/7 | |  71 |  21 | 521+1/7 | |  94 |  44 | 659+1/7 |
		// |   3 | C13 | 111+1/7 | |  26 | C27 | 249+1/7 | |  49 | C50 | 387+1/7 | |  72 |  22 | 527+1/7 | |  95 |  45 | 665+1/7 |
		// |   4 | C14 | 117+1/7 | |  27 | C28 | 255+1/7 | |  50 | C51 | 393+1/7 | |  73 |  23 | 533+1/7 | |  96 |  46 | 671+1/7 |
		// |   5 | C15 | 123+1/7 | |  28 | C29 | 261+1/7 | |  51 | C52 | 399+1/7 | |  74 |  24 | 539+1/7 | |  97 |  47 | 677+1/7 |
		// |   6 | C16 | 129+1/7 | |  29 | C30 | 267+1/7 | |  52 | C53 | 405+1/7 | |  75 |  25 | 545+1/7 | |  98 |  48 | 683+1/7 |
		// |   7 | C17 | 135+1/7 | |  30 | C31 | 273+1/7 | |  53 | C54 | 411+1/7 | |  76 |  26 | 551+1/7 | |  99 |  49 | 689+1/7 |
		// |   8 | C18 | 141+1/7 | |  31 | C32 | 279+1/7 | |  54 | C55 | 417+1/7 | |  77 |  27 | 557+1/7 | | 100 |  50 | 695+1/7 |
		// |   9 | C19 | 147+1/7 | |  32 | C33 | 285+1/7 | |  55 | C56 | 423+1/7 | |  78 |  28 | 563+1/7 | | 101 |  51 | 701+1/7 |
		// |  10 | C20 | 153+1/7 | |  33 | C34 | 291+1/7 | |  56 | C57 | 429+1/7 | |  79 |  29 | 569+1/7 | | 102 |  52 | 707+1/7 |
		// |  11 | C21 | 159+1/7 | |  34 | C35 | 297+1/7 | |  57 | C58 | 435+1/7 | |  80 |  30 | 575+1/7 | | 103 |  53 | 713+1/7 |
		// |  12 | C22 | 167+1/7 | |  35 | C36 | 303+1/7 | |  58 | C59 | 441+1/7 | |  81 |  31 | 581+1/7 | | 104 |  54 | 719+1/7 |
		// |  13 |   4 | 173+1/7 | |  36 | C37 | 309+1/7 | |  59 | C60 | 447+1/7 | |  82 |  32 | 587+1/7 | | 105 |  55 | 725+1/7 |
		// |  14 |   5 | 179+1/7 | |  37 | C38 | 315+1/7 | |  60 | C61 | 453+1/7 | |  83 |  33 | 593+1/7 | | 106 |  56 | 731+1/7 |
		// |  15 |   6 | 185+1/7 | |  38 | C39 | 321+1/7 | |  61 | C62 | 459+1/7 | |  84 |  34 | 599+1/7 | | 107 |  57 | 737+1/7 |
		// |  16 |   7 | 191+1/7 | |  39 | C40 | 327+1/7 | |  62 | C63 | 465+1/7 | |  85 |  35 | 605+1/7 | | 108 |  58 | 743+1/7 |
		// |  17 |   8 | 195+1/7 | |  40 | C41 | 333+1/7 | |  63 |  13 | 473+1/7 | |  86 |  36 | 611+1/7 | | 109 |  59 | 749+1/7 |
		// |  18 |   9 | 201+1/7 | |  41 | C42 | 339+1/7 | |  64 |  14 | 479+1/7 | |  87 |  37 | 617+1/7 | | 110 |  60 | 755+1/7 |
		// |  19 |  10 | 207+1/7 | |  42 | C43 | 345+1/7 | |  65 |  15 | 485+1/7 | |  88 |  38 | 623+1/7 | | 111 |  61 | 761+1/7 |
		// |  20 |  11 | 213+1/7 | |  43 | C44 | 351+1/7 | |  66 |  16 | 491+1/7 | |  89 |  39 | 629+1/7 | | 112 |  62 | 767+1/7 |
		// |  21 |  12 | 219+1/7 | |  44 | C45 | 357+1/7 | |  67 |  17 | 497+1/7 | |  90 |  40 | 635+1/7 | +-----+-----+---------+
		// |  22 | C23 | 225+1/7 | |  45 | C46 | 363+1/7 | |  68 |  18 | 503+1/7 | |  91 |  41 | 641+1/7 |
		// +-----+-----+---------+ +-----+-----+---------+ +-----+-----+---------+ +-----+-----+---------+
		// 
		// C24`C27 ́AP[uerǂɂ艺L̎gőMĂꍇ܂B
		// +-----+---------+
		// | Ch. | f (MHz) |
		// +-----+---------+
		// | C24 | 233+1/7 |
		// | C25 | 239+1/7 |
		// | C26 | 245+1/7 |
		// | C27 | 251+1/7 |
		// +-----+---------+

		// ----------
		// g덷
		// ----------

		// [@\] g덷擾
		// [] l̈Ӗ͎̒ʂłB
		//        NbNg덷: clock/100 (ppm)
		//        LAg덷: carrier (Hz)
		//        g̎gx͏\ɍ肷ƁA덷vfƂĈȉ̂悤Ȃ̂l܂B
		//        (ISDB-S) LNB ł̎gϊx / q PLL-IC ɐڑĂUq̐x /  IC ɐڑĂUq̐x
		//        (ISDB-T) n㑤 PLL-IC ɐڑĂUq̐x /  IC ɐڑĂUq̐x
		// [Ԓl] STATUS_DEVICE_IS_NOT_OPEN_ERROR  foCXI[vĂȂ
		//        STATUS_INVALID_PARAM_ERROR        tuner  1 傫 isdb ͈͊O
		//                                            clock, carrier ̂ꂩ NULL
		//        STATUS_TUNER_IS_SLEEP_ERROR      `[i[ȓd͏
		virtual status GetFrequencyOffset(ISDB isdb, uint32 tuner, sint32 *clock, sint32 *carrier) = 0;

		// --------
		// C/NEAGC
		// --------

		// [@\] C/N  AGC 擾
		// [] C/N ͒჌CeVőł邽߁AAeǐ𒲐̂ɕ֗łB
		//        l̈Ӗ͎̒ʂłB
		//        C/N                : cn100/100 (dB)
		//        ݂ AGC l      : currentAgc
		//        ő厞 AGC l: maxAgc
		//        currentAgc ͈̔͂ 0  maxAgc ܂łłB
		// [Ԓl] STATUS_DEVICE_IS_NOT_OPEN_ERROR  foCXI[vĂȂ
		//        STATUS_INVALID_PARAM_ERROR        tuner  1 傫 isdb ͈͊O
		//                                            cn100, currentAgc, maxAgc ̂ꂩ NULL
		//        STATUS_TUNER_IS_SLEEP_ERROR      `[i[ȓd͏
		virtual status GetCnAgc(ISDB isdb, uint32 tuner, uint32 *cn100, uint32 *currentAgc, uint32 *maxAgc) = 0;

		// ----------------------
		// RF Level (ISDB-T ̂)
		// ----------------------
		virtual status GetRFLevel(uint32 tuner, float *level) = 0;

		// -------------------
		// TS-ID (ISDB-S ̂)
		// -------------------

		// [@\] TS-ID ݒ
		// [] ݒlIC ̓ɔf܂ŎԂ|܂B
		//        GetLayerS() ĂяoOɁAGetIdS() gĐ؂ւƂmFĂB
		// [Ԓl] STATUS_DEVICE_IS_NOT_OPEN_ERROR  foCXI[vĂȂ
		//        STATUS_INVALID_PARAM_ERROR        tuner  1 傫
		virtual status SetIdS(uint32 tuner, uint32 id) = 0;

		// [@\] ݏ TS-ID 擾
		// [] GetLayerS() Ŏ擾ł郌ĆÅ֐Ŏ TS-ID ̂̂ɂȂ܂B
		// [Ԓl] STATUS_DEVICE_IS_NOT_OPEN_ERROR  foCXI[vĂȂ
		//        STATUS_INVALID_PARAM_ERROR        tuner  1 傫B܂͈ id  NULL
		virtual status GetIdS(uint32 tuner, uint32 *id) = 0;

		// ------------
		// G[[g
		// ------------

		// KwCfbNX
		enum LayerIndex {
			// ISDB-S
			LAYER_INDEX_L = 0,	// Kw
			LAYER_INDEX_H,		// Kw

			// ISDB-T
			LAYER_INDEX_A = 0,	// A Kw
			LAYER_INDEX_B,		// B Kw
			LAYER_INDEX_C		// C Kw
		};

		// Kw
		enum LayerCount {
			// ISDB-S
			LAYER_COUNT_S = LAYER_INDEX_H + 1,

			// ISDB-T
			LAYER_COUNT_T = LAYER_INDEX_C + 1
		};

		// G[[g
		struct ErrorRate {
			uint32 Numerator, Denominator;
		};

		// [@\] GetInnerErrorRate() őΏۂƂȂKwݒ
		virtual status SetInnerErrorRateLayer(ISDB isdb, uint32 tuner, LayerIndex layerIndex) = 0;

		// [@\] ŒꂽG[[g擾
		virtual status GetInnerErrorRate(ISDB isdb, uint32 tuner, ErrorRate *errorRate) = 0;

		// [@\] [h\ŒꂽG[[g擾
		// [] ɎԂ|܂AMi𐳊mɔcɂ C/N ł͂Ȃ̃G[[gQlɂĂB
		//        ЂƂ̖ڈƂ 2~10^-4 ȉł΁A[h\ɂقڃG[t[ɂȂƂĂ܂B
		//        G[[g̏WvPʂ͎̒ʂłB
		//        ISDB-S: 1024 t[
		//        ISDB-T: 32 t[ ([h 1,2) / 8 t[ ([h 3)
		// [Ԓl] STATUS_DEVICE_IS_NOT_OPEN_ERROR  foCXI[vĂȂ
		//        STATUS_INVALID_PARAM_ERROR        tuner, isdb, layerIndex ͈͊OB܂ errorRate  NULL
		virtual status GetCorrectedErrorRate(ISDB isdb, uint32 tuner, LayerIndex layerIndex, ErrorRate *errorRate) = 0;

		// [@\] [h\ŒꂽG[[gvZ邽߂̃G[JE^
		// [] SKw̃JE^܂B̊Kw̃JE^Zbg邱Ƃ͂ł܂B
		// [Ԓl] STATUS_DEVICE_IS_NOT_OPEN_ERROR  foCXI[vĂȂ
		//        STATUS_INVALID_PARAM_ERROR        tuner  1 傫 isdb ͈͊O
		virtual status ResetCorrectedErrorCount(ISDB isdb, uint32 tuner) = 0;

		// [@\] [h\ŒȂ TS pPbg擾
		// [] 0xffffffff ̎ 0x00000000 ɂȂ܂B
		//        TS pPbg 2nd Byte MSB 𐔂ĂlɂȂ܂B
		//        ̃JE^ DMA ]Jnɏ܂B
		// [Ԓl] STATUS_DEVICE_IS_NOT_OPEN_ERROR  foCXI[vĂȂ
		//        STATUS_INVALID_PARAM_ERROR        tuner  1 傫 isdb ͈͊OB܂͈ count  NULL
		virtual status GetErrorCount(ISDB isdb, uint32 tuner, uint32 *count) = 0;

		// --------------------------
		// TMCCEC[EbN
		// --------------------------

		// ISDB-S TMCC 
		// (Ql) STD-B20 2.9 TMCC̍\ ` 2.11 TMCC̍XV
		struct TmccS {
			uint32 Indicator;	// ύXw (5rbg)
			uint32 Mode[4];		// `[hn (4rbg)
			uint32 Slot[4];		// `[hnւ̊Xbg (6rbg)
								// [TS^Xbg͎擾ł܂]
			uint32 Id[8];		// TSԍnɑ΂TS ID (16rbg)
			uint32 Emergency;	// NM (1rbg)
			uint32 UpLink;		// AbvN (4rbg)
			uint32 ExtFlag;		// gtO (1rbg)
			uint32 ExtData[2];	// g̈ (61rbg)
		};

		// [@\] ISDB-S  TMCC 擾
		// [Ԓl] STATUS_DEVICE_IS_NOT_OPEN_ERROR  foCXI[vĂȂ
		//        STATUS_INVALID_PARAM_ERROR        tuner  1 傫 tmcc  NULL
		virtual status GetTmccS(uint32 tuner, TmccS *tmcc) = 0;

		// ISDB-S Kw
		struct LayerS {
			uint32 Mode [LAYER_COUNT_S];	// `[h (3rbg) 
			uint32 Count[LAYER_COUNT_S];	// _~[Xbg܂߂Xbg (6rbg)
		};

		// [@\] ISDB-S ̃C擾
		// [Ԓl] STATUS_DEVICE_IS_NOT_OPEN_ERROR  foCXI[vĂȂ
		//        STATUS_INVALID_PARAM_ERROR        tuner  1 傫 layerS  NULL
		virtual status GetLayerS(uint32 tuner, LayerS *layerS) = 0;

		// ISDB-T TMCC 
		// (Ql) STD-B31 3.15.6 TMCC ` 3.15.6.8 ZOg
		struct TmccT {
			uint32 System;						// VXe (2rbg)
			uint32 Indicator;					// `p[^؂ւwW (4rbg)
			uint32 Emergency;					// ً}xpNtO (1rbg)
												// Jg
			uint32 Partial;						// MtO (1rbg)
												// Kw
			uint32 Mode      [LAYER_COUNT_T];	// LAϒ (3rbg)
			uint32 Rate      [LAYER_COUNT_T];	// 􍞂ݕ (3rbg)
			uint32 Interleave[LAYER_COUNT_T];	// C^[[u (3rbg)
			uint32 Segment   [LAYER_COUNT_T];	// ZOg (4rbg)
												// [lNXg͎擾ł܂]
			uint32 Phase;						// AMʑ␳ (3rbg)
			uint32 Reserved;					// U[u (12rbg)
		};

		// [@\] ISDB-T  TMCC 擾
		// [Ԓl] STATUS_DEVICE_IS_NOT_OPEN_ERROR  foCXI[vĂȂ
		//        STATUS_INVALID_PARAM_ERROR        tuner  1 傫 tmcc  NULL
		virtual status GetTmccT(uint32 tuner, TmccT *tmcc) = 0;

		// [@\] ISDB-T bN擾
		// [] C݂AȂ̃CG[t[łƂ true ɂȂ܂B
		// [Ԓl] STATUS_DEVICE_IS_NOT_OPEN_ERROR  foCXI[vĂȂ
		//        STATUS_INVALID_PARAM_ERROR        tuner  1 傫 locked  NULL
//		virtual status GetLockedT(uint32 tuner, bool locked[LAYER_COUNT_T]) = 0;

		// [@\] ISDB-T ̓̓Av̓d
		virtual status SetAmpPowerT(bool b) = 0;

		// MKw
		enum LayerMask {
			LAYER_MASK_NONE,

			// ISDB-S
			LAYER_MASK_L = 1 << LAYER_INDEX_L,
			LAYER_MASK_H = 1 << LAYER_INDEX_H,

			// ISDB-T
			LAYER_MASK_A = 1 << LAYER_INDEX_A,
			LAYER_MASK_B = 1 << LAYER_INDEX_B,
			LAYER_MASK_C = 1 << LAYER_INDEX_C
		};

		// [@\] MKw̐ݒ
		// [] ISDB-S ̒KwMȂ悤ɐݒ肷邱Ƃ͂ł܂B
		// [Ԓl] STATUS_DEVICE_IS_NOT_OPEN_ERROR  foCXI[vĂȂ
		//        STATUS_INVALID_PARAM_ERROR        tuner  1 傫 isdb ͈͊O
		//                                            layerMask ͈͊O (SetLayerEnable ̂)
		//                                            layerMask  NULL (GetLayerEnable ̂)
		virtual status SetLayerEnable(ISDB isdb, uint32 tuner, LayerMask  layerMask)       = 0;
		virtual status GetLayerEnable(ISDB isdb, uint32 tuner, LayerMask *layerMask) const = 0;

		// -------------
		// TS seXg
		// -------------
		enum TsPinMode {
			TS_PIN_MODE_NORMAL,
			TS_PIN_MODE_LOW,
			TS_PIN_MODE_HIGH
		};

		struct TsPinsMode {
			TsPinMode	clock_data,
						byte,
						valid;
		};

		struct TsPinsLevel {
			bool	clock,	// gO
					data,
					byte,
					valid;
		};

		virtual status SetTsPinsMode (ISDB isdb, uint32 tuner, const TsPinsMode  *mode ) = 0;
		virtual status GetTsPinsLevel(ISDB isdb, uint32 tuner,       TsPinsLevel *level) = 0;

		virtual status GetTsSyncByte(ISDB isdb, uint32 tuner, uint8 *syncByte) = 0;

		enum RamPinsMode {
			RAM_PINS_MODE_NORMAL,
			RAM_PINS_MODE_LOW,
			RAM_PINS_MODE_HIGH
		};

		virtual status SetRamPinsMode(RamPinsMode mode) = 0;

		// ------------------
		// DMA ]pobt@
		// ------------------

		// ̊֐͔p~܂BLockBuffer() pB
		virtual status LockBuffer__Obsolated__(void *ptr, uint32 size, void **handle) = 0;
		virtual status UnlockBuffer(void *handle) = 0;

		struct BufferInfo {
			uint64 Address;		// AhX
			uint32 Size;		// TCY
		};

		virtual status GetBufferInfo(void *handle, const BufferInfo **infoTable, uint32 *infoCount) = 0;

		// --------
		// DMA ]
		// --------

		// [@\] DMA JnE~̐
		// [] DMA ]͑S CPU ݂邱ƂȂ삵܂B
		//        GetTransferEnabled()  true  Ƃ SetTransferEnabled(true ) ƂA
		//        GetTransferEnabled()  false Ƃ SetTransferEnabled(false) ƂƃG[ɂȂ܂B
		//        
		//        GetTransferEnabled() Ŏ擾łĺAP SetTransferEnabled() ōŌɐݒ肳ꂽlƓłB
		//        ]JE^ 0 ɂȂȂǁAn[hEFA DMA ]Iɒ~v܂A
		//        ̏ꍇł GetTransferEnabled() œl͕ς܂B
		virtual status SetTransferPageDescriptorAddress(ISDB isdb, uint32 tunerIndex, uint64 pageDescriptorAddress) = 0;
		virtual status SetTransferEnabled              (ISDB isdb, uint32 tunerIndex, bool  enabled)       = 0;
		virtual status GetTransferEnabled              (ISDB isdb, uint32 tunerIndex, bool *enabled) const = 0;
		
		// resetError  TS G[pPbg̃ZbgłBIɂ͕ʊ֐Ɉړ܂B
		virtual status SetTransferTestMode(ISDB isdb, uint32 tunerIndex, bool testMode = false, uint16 initial = 0, bool not = false/*, bool resetError = false*/) = 0;
		
		struct TransferInfo {
			bool	Busy;
			uint32	Status;						// 4rbg
			bool	InternalFIFO_A_Overflow,
					InternalFIFO_A_Underflow;
			bool	ExternalFIFO_Overflow;
			uint32	ExternalFIFO_MaxUsedBytes;	// ExternalFIFO_Overflow  false ̏ꍇ̂ݗL
			bool	InternalFIFO_B_Overflow,
					InternalFIFO_B_Underflow;
		};

		virtual status GetTransferInfo(ISDB isdb, uint32 tunerIndex, TransferInfo *transferInfo) = 0;

		// ---------------------
		// 0.96 Œǉꂽ֐
		// ---------------------

		enum TransferDirection {				// DMA ̓]
			TRANSFER_DIRECTION_WRITE = 1 << 0,	// PCI foCXɃf[^
			TRANSFER_DIRECTION_READ	 = 1 << 1,	// PCI foCX̃f[^ǂݍ
			TRANSFER_DIRECTION_WRITE_READ = TRANSFER_DIRECTION_WRITE | TRANSFER_DIRECTION_READ
		};

		// [@\] ̈𕨗ɌŒ肷
		// [] DMA ]p̈ DMA ]JnOɕɌŒ肷Kv܂B
		//        ptr  size Ń̈w肵Adirection  DMA ]w肵܂B
		//        handle ŕԂꂽ|C^ UnlockBuffer(), SyncBufferCpu(), SyncBufferDevice() Ŏgp܂B
		virtual status LockBuffer(void *ptr, uint32 size, TransferDirection direction, void **handle) = 0;

		// [@\] CPU LbV DMA ]p̈̓
		// [] LɋLڂsNȂ悤ɁÅ֐ĂœKv܂B
		//        (P[X1)
		//        1. CPU  DMA ]p̈Ƀf[^
		//        2. ܂ꂽf[^ CPU LbVɑ݂邾 DMA ]p̈ɂ͖܂ĂȂ
		//        3. PCI foCX DMA ]p̈Ƀf[^
		//        4. CPU LbVɑ݂f[^ DMA ]p̈ɏ (s)
		//        sȂ悤 2 ̌ɂ̊֐ĂłB
		//        
		//        (P[X2)
		//        1. PCI foCX DMA ]p̈Ƀf[^
		//        2. CPU ]pf[^ǂݍ
		//        3. ǂݍ񂾃f[^ CPU ̃LbVɕۑ
		//        4. PCI foCX DMA ]p̈ɁuVvf[^
		//        5. CPU ]pf[^ǂݍ
		//        6. CPU  DMA ]p̈ɂuVvf[^ł͂ȂALbVꂽÂf[^ǂݍ (s)
		//        sȂ悤 5 ̑Oɂ̊֐ĂłB
		virtual status SyncBufferCpu(void *handle) = 0;

		// [@\] I/O LbV DMA ]p̈̓
		// [] LɋLڂsNȂ悤ɁÅ֐ĂœKv܂B
		//        1. PCI foCX DMA ]p̈Ƀf[^ނ߂ɃpPbg𑗏o
		//        2. pPbg󂯎fCoX͌Ńf[^̃foCXɑo邽߁AgŃf[^LbV
		//        3. ăf[^͖ DMA ]p̈ɏ܂ĂȂ
		//        4. CPU  PCI foCXu]IipPbgoIjvł邱ƂmF
		//        5. DMA ]p̈悩f[^ǂݍ (s)
		//        sȂ悤 5 ̑Oɂ̊֐ĂłB
		virtual status SyncBufferIo(void *handle) = 0;
		
	protected:
		virtual ~Device() {}
	};

	enum Status {
		// G[Ȃ
		STATUS_OK,

		// ʓIȃG[
		STATUS_GENERAL_ERROR = (1)*0x100,
		STATUS_NOT_IMPLIMENTED,
		STATUS_INVALID_PARAM_ERROR,
		STATUS_OUT_OF_MEMORY_ERROR,
		STATUS_INTERNAL_ERROR,

		// oXNX̃G[
		STATUS_WDAPI_LOAD_ERROR = (2)*256,	// wdapi####.dll [hłȂ [#### ̓o[Wԍ]
		STATUS_ALL_DEVICES_MUST_BE_DELETED_ERROR,

		// foCXNX̃G[
		STATUS_PCI_BUS_ERROR = (3)*0x100,
		STATUS_CONFIG_REVISION_ERROR,
		STATUS_FPGA_VERSION_ERROR,
		STATUS_PCI_BASE_ADDRESS_ERROR,
		STATUS_FLASH_MEMORY_ERROR,

		STATUS_DCM_LOCK_TIMEOUT_ERROR,
		STATUS_DCM_SHIFT_TIMEOUT_ERROR,

		STATUS_POWER_RESET_ERROR,
		STATUS_I2C_ERROR,
		STATUS_TUNER_IS_SLEEP_ERROR,

		STATUS_PLL_OUT_OF_RANGE_ERROR,
		STATUS_PLL_LOCK_TIMEOUT_ERROR,

		STATUS_VIRTUAL_ALLOC_ERROR,
		STATUS_DMA_ADDRESS_ERROR,
		STATUS_BUFFER_ALREADY_ALLOCATED_ERROR,

		STATUS_DEVICE_IS_ALREADY_OPEN_ERROR,
		STATUS_DEVICE_IS_NOT_OPEN_ERROR,

		STATUS_BUFFER_IS_IN_USE_ERROR,
		STATUS_BUFFER_IS_NOT_ALLOCATED_ERROR,

		STATUS_DEVICE_MUST_BE_CLOSED_ERROR,

		// WinDriver ֘ÃG[
		STATUS_WD_DriverName_ERROR = (4)*0x100,

		STATUS_WD_Open_ERROR,
		STATUS_WD_Close_ERROR,

		STATUS_WD_Version_ERROR,
		STATUS_WD_License_ERROR,

		STATUS_WD_PciScanCards_ERROR,

		STATUS_WD_PciConfigDump_ERROR,

		STATUS_WD_PciGetCardInfo_ERROR,
		STATUS_WD_PciGetCardInfo_Bus_ERROR,
		STATUS_WD_PciGetCardInfo_Memory_ERROR,

		STATUS_WD_CardRegister_ERROR,
		STATUS_WD_CardUnregister_ERROR,

		STATUS_WD_CardCleanupSetup_ERROR,

		STATUS_WD_DMALock_ERROR,
		STATUS_WD_DMAUnlock_ERROR,

		STATUS_WD_DMASyncCpu_ERROR,
		STATUS_WD_DMASyncIo_ERROR,

		// ROM
		STATUS_ROM_ERROR = (5)*0x100,
		STATUS_ROM_TIMEOUT
	};
}
}

#endif
