//
// InternetTextMessage.cpp
//

#include "net/InternetTextMessage.h"

using namespace Raym;

namespace NET
{

InternetTextMessage::InternetTextMessage()
{
    _header = NULL;
    _body = NULL;
}

InternetTextMessage::~InternetTextMessage()
{
    if (_body != NULL)
    {
        _body->release();
        _body = NULL;
    }
    if (_header != NULL)
    {
        _header->release();
        _header = NULL;
    }
}

InternetTextMessage *InternetTextMessage::alloc()
{
    return new InternetTextMessage();
}

InternetTextMessage *InternetTextMessage::initWithContentsOfFile(const char *path)
{
    /*
    NSFileManager *fm = [NSFileManager defaultManager];
    return [self initWithData:[fm contentsAtPath:path]];
    */
    release();
    return NULL;
}

InternetTextMessage *InternetTextMessage::initWithData(Data *data)
{
    /*
    if ((self = [super init]) != nil)
    {
        _header = nil;
        _body = nil;

        char *tmp = "\r\n\r\n";
        Data *crlfcrlf = [Data dataWithBytes:tmp length:4];
        NSRange r = {0, [data length]};
        r = [data rangeOfData:crlfcrlf options:0 range:r];
        if (r.location != NSNotFound)
        {
            NSRange rh = {0, r.location + 4};
            Data *dh = [data subdataWithRange:rh];
            _header = [[InternetTextMessageHeader alloc] initWithData:dh];
            NSRange rb = {r.location + 4, ([data length] - (r.location + 4))};
            Data *db = [data subdataWithRange:rb];
            _body = [[InternetTextMessageBody alloc] initWithData:db];
        }
        else
        {
            [self release];
            self = nil;
        }
    }
    */
    release();
    return NULL;
}

InternetTextMessage *InternetTextMessage::initWithHeaderAndBody(InternetTextMessageHeader *header, InternetTextMessageBody *body)
{
    if (header != NULL)
    {
        _header = header->retain();
        if (body != NULL)
        {
            _body = body->retain();
        }
        return this;
    }

    release();
    return NULL;
}

InternetTextMessage *InternetTextMessage::retain()
{
    Object::retain();
    return this;
}

InternetTextMessage *InternetTextMessage::autorelease()
{
    Object::autorelease();
    return this;
}

InternetTextMessageHeader *InternetTextMessage::header()
{
    return _header;
}

InternetTextMessageBody *InternetTextMessage::body()
{
    return _body;
}

Data *InternetTextMessage::data()
{
    /*
    NSMutableData *result = [NSMutableData dataWithData:[_header data]];
    if ([_body data])
    {
        [result appendData:[_body data]];
    }
    else
    {
        [result appendData:[[_body body] dataUsingEncoding:[_header encoding]]];
    }
    */
    return NULL;
}

const char *InternetTextMessage::className()
{
    return "NET::InternetTextMessage";
}

} // NET
