//
//  HTTPRequest.h
//

#ifndef __NET_HTTPREQUEST_H__
#define __NET_HTTPREQUEST_H__

#include <Raym/Raym.h>

#include "net/InternetTextMessage.h"

namespace NET
{

class HTTPRequest : public Raym::Object
{
private:
    Raym::String *  _method;
    Raym::String *  _uri;
    Raym::String *  _version;
    InternetTextMessage *   _message;

protected:
    HTTPRequest();
    ~HTTPRequest();

public:
    static HTTPRequest *requestWithSocket(SOCKET sock);

    void setMethod(Raym::String *method);
    Raym::String *method();
    void setURI(Raym::String *uri);
    Raym::String *URI();
    void setVersion(Raym::String *version);
    Raym::String *version();
    void setMessage(InternetTextMessage *message);
    InternetTextMessage *message();


    // parse
    static const char *KEY_CGI;
    static const char *KEY_PARAMS;
    Raym::Dictionary *parseAsCGI();

    virtual const char *className();
};

} // NET

#endif // __NET_HTTPREQUEST_H__
