/**
 * @file keys.h
 *
 */

#pragma once

// general
static const char *KEY_NAME                                                 = "Name";
static const char *KEY_CHANNEL                                              = "Channel";

// system
static const char *KEY_VERSION                                              = "Version";
static const char *KEY_HOSTNAME                                             = "Hostname";
static const char *KEY_HTTP_HOST                                            = "HTTP Host";
static const char *KEY_HTTP_PORT                                            = "HTTP Port";
static const char *KEY_STORE_PATH                                           = "Store Path";
static const char *KEY_FORCED_SHUTDOWN                                      = "Forced Shutdown";
static const char *KEY_DO_NOT_IN_SHUTDOWN                                   = "Do not in shutdown";
static const char *KEY_COLLECT_EPG_TIME                                     = "Time to Collect EPG";
static const char *KEY_BEGIN_UDP_PORT                                       = "Begin of UDP Port";
static const char *KEY_CACHE_PATH                                           = "Cache Path";
static const char *KEY_MAPPING_UDP_TO_TUNER_SERVICE_ID                      = "Mapping for UDP Port to Tuner and Service ID";
static const char *KEY_MAPPING_TUNER_SERVICE_ID_TO_UDP                      = "Mapping for Tuner and Service ID to UDP Port";
static const char *KEY_MAPPING_TUNER_SERVICE_ID_TO_CHANNEL                  = "Mapping for Tuner and Service ID to Channel";
static const char *KEY_UDP_IN_USE                                           = "UDP in use";
static const char *KEY_HLS_INFO                                             = "HLS Information";
static const char *KEY_HLS_INSTANCE                                         = "HLS Instance";
static const char *KEY_PRESETS                                              = "Presets";
static const char *KEY_PRESET                                               = "Preset";
static const char *KEY_POWER_MANAGER                                        = "Power Manager";
static const char *KEY_DEFAULT                                              = "default";

static const char *KEY_TUNERS                                               = "Tuners";
static const char *KEY_INITIALIZED                                          = "Initialized";
static const char *KEY_ENABLED                  = "Enabled";
static const char *KEY_TYPE                     = "Type";
static const char *KEY_CHANNELS                 = "Channels";
static const char *KEY_CHANNEL_ID               = "Channel ID";
static const char *KEY_SERVICES                 = "Services";
static const char *KEY_SERVICE_ID               = "Service ID";
static const char *KEY_SERVICE_TYPE             = "Service Type";
static const char *KEY_LNB_POWER                = "LNB Power";
static const char *KEY_CN                       = "C_N";
static const char *KEY_AGC                      = "AGC";
static const char *KEY_MAX_AGC                  = "Max AGC";
static const char *KEY_TEMP_DATA                                            = "Temp Data";
static const char *KEY_IPTV_ENABLED                                         = "IPTV Enabled";
static const char *KEY_PROGRAMS                                             = "Programs";

static const char *KEY_RESULT                   = "Result";

// EPG
#define KEY_EPG_EVENT_ID                                        "Event ID"
#define KEY_EPG_DATE                                            "Date"
#define KEY_EPG_START                                           "Start"
#define KEY_EPG_END                                             "End"
#define KEY_EPG_DURATION                                        "Duration"
#define KEY_EPG_TITLE                                           "Title"
#define KEY_EPG_DESCRIPTION                                     "Description"
#define KEY_EPG_CHANNEL                                         "Channel"
#define KEY_EPG_STATUS                                          "Status"
#define KEY_EPG_SERVICE_ID                                      "Service ID"
#define KEY_EPG_RESV_ID                                         "Reservation ID"
#define KEY_EPG_LAST_RESV_ID                                    "Last Reservation ID"
#define KEY_EPG_REPEAT                                          "Repeat"
#define KEY_EPG_KEYWORDS                                        "Keywords"
#define KEY_EPG_RESERVED_BY_KEYWORDS                            "Reserved by keywords"
#define KEY_EPG_EXT_ITEM_DESCRIPTION                            "Extended Item Description"
#define KEY_EPG_EXT_ITEM                                        "Extended Item"
#define KEY_EPG_EXT_ITEMS                                       "Extended Items"

// ローカライズ用キー
#define KEY_I18N_Main_Menu                                      "Main Menu"
#define KEY_I18N_Reservation                                    "Reservation"
#define KEY_I18N_New_Reservation                                "New Reservation"
#define KEY_I18N_Registration                                   "Registration"
#define KEY_I18N_Keywords                                       "Keywords"
#define KEY_I18N_Add                                            "Add"
#define KEY_I18N_Tuner_Status                                   "Tuner Status"
#define KEY_I18N_Tuner                                          "Tuner"
#define KEY_I18N_Station_Name                                   "Station Name"
#define KEY_I18N_Date                                           "Date"
#define KEY_I18N_Start_Time                                     "Start Time"
#define KEY_I18N_End_Time                                       "End Time"
#define KEY_I18N_Time                                           "Time"
#define KEY_I18N_Stop                                           "Stop"
#define KEY_I18N_Cancel                                         "Cancel"
#define KEY_I18N_Delete                                         "Delete"
#define KEY_I18N_Programs                                       "Programs"
#define KEY_I18N_TV                                             "TV"
#define KEY_I18N_Video                                          "Video"
#define KEY_I18N_Repeat                                         "Repeat"
#define KEY_I18N_Repeat_off                                     "Repeat_off"
#define KEY_I18N_Repeat_everyday                                "Repeat_everyday"
#define KEY_I18N_Repeat_weekly                                  "Repeat_weekly"
#define KEY_I18N_Repeat_weekday                                 "Repeat_weekday"
#define KEY_I18N_Digital_Terrestrial_Television_Broadcasting    "Digital Terrestrial Television Broadcasting"
#define KEY_I18N_Broadcasting_Time                              "Broadcasting Time"
#define KEY_I18N_Program_Title                                  "Program Title"
#define KEY_I18N_Description                                    "Description"

// other
static const char * KEY_COUNTER = "Counter";
