//
// URLResponse.h
//

#pragma once

#include <Raym/Object.h>
#include <Raym/URL.h>

namespace Raym
{

#define URLResponseUnknownLength ((long long)-1)

class URLResponse : public Object
{
protected:
    URLResponse();
    ~URLResponse();

    URL *       _URL;
    String *    _MIMEType;
    long long   _expectedContentLength;
    String *    _textEncodingName;

public:
    static URLResponse *alloc();

    URLResponse *initWithURL(URL *URL, String *MIMEType, long long expectedContentLength, String *textEncodingName);
    String *MIMEType();
    String *suggestedFilename();
    String *textEncodingName();
    URL *url();
    long long expectedContentLength();

//    virtual String *description();
    virtual const char *className();
};

} // Raym
