﻿//
//
//

#ifndef __RAYM_LOG_H__
#define __RAYM_LOG_H__

#ifdef _WIN32
#else
#include <stdio.h>
#include <stdarg.h>
#endif

namespace Raym
{

#ifdef _WIN32
extern void Log(const char *format, ...);
#else
inline void Log(const char *format, ...)
{
    va_list ap;
    va_start(ap, format);
    vprintf(format, ap);
    va_end(ap);
}
#endif
extern int LOG_NUM_MAX;

} // Raym

#ifndef DBG_LEVEL
#define DBG_LEVEL 0
#endif

// 常時出力
#define DebugLog0(...) Raym::Log(__VA_ARGS__)

// システムログ
#if DBG_LEVEL >= 1
#define DebugLog1(...) Raym::Log(__VA_ARGS__)
#else
#define DebugLog1(...)
#endif

// 走行ルート確認用
#if DBG_LEVEL >= 2
#define DebugLog2(...) Raym::Log(__VA_ARGS__)
#else
#define DebugLog2(...)
#endif

// 詳細エラー用
#if DBG_LEVEL >= 3
#define DebugLog3(...) Raym::Log(__VA_ARGS__)
#else
#define DebugLog3(...)
#endif

// コンソール出力用
#if DBG_LEVEL >= 4
#define DebugLog4(...) printf(__VA_ARGS__)
#else
#define DebugLog4(...)
#endif

#endif // __RAYM_LOG_H__
