//
// FileManager.h
//

#pragma once

#include "Raym/Object.h"
#include "Raym/Error.h"

namespace Raym
{

class FileManager : public Object
{
protected:
    FileManager();
    ~FileManager();

public:
    static FileManager *defaultManager();

    bool fileExistsAtPath(String *path, bool *isDirectory);
    bool fileExistsAtPath(const char *path, bool *isDirectory);

    bool removeItemAtPath(String *path, Error **error);

    virtual const char *className();

    // utility
    static int freeSpaceForPath(String *path);
};

} // Raym

