﻿//
//
//

#pragma once

#include "Raym/Raym.h"

namespace ry0
{
namespace iPTd
{

class CommandRunner : public Raym::Object
{
private:
    enum _state
    {
        ST_IDLE,
        ST_READY,
        ST_RUN,
        ST_DONE
    }                       _state;
    Raym::String *  _command;
    Raym::Array *   _arguments;

protected:
    CommandRunner();
    ~CommandRunner();

    virtual bool readLine(Raym::String *line);
    void write(Raym::String *line);

public:
    static CommandRunner *alloc();
    CommandRunner *init();
    CommandRunner *retain();
    CommandRunner *autorelease();

    void setCommandPath(Raym::String *path);
    void setArguments(Raym::Array *args);

    void run();
    bool start();
    void stop();
    bool isRunning();

    virtual const char *className();
};

} // iPTd
} // ry0
