/**
 * @file Header.h
 *
 */
#pragma once

#include <stdint.h>

namespace MPEG2
{
namespace TS
{

enum
{
    SYNC_BYTE   = 0x47,
    PACKET_SIZE = 188,
};

enum
{
    PID_PAT         = 0x0000,
    PID_CAT         = 0x0001,
    PID_NIT         = 0x0010,
    PID_SDT_BAT     = 0x0011,
    PID_EIT_0012    = 0x0012,
    PID_EIT_0026    = 0x0026,
    PID_EIT_0027    = 0x0027,
    PID_RST         = 0x0013,
    PID_TDT         = 0x0014,
};

class Header
{
public:
    uint8_t     _sync_byte;                     //  8
    uint8_t     _transport_error;               //  1
    uint8_t     _payload_unit_start;            //  1
    uint8_t     _transport_priority;            //  1
    uint16_t    _pid;                           // 13
    uint8_t     _transport_scramble_control;    //  2
    uint8_t     _adaptation_field_control;      //  2
    uint8_t     _continuity_counter;            //  4

    Header(uint8_t *packet);
};

} // TS
} // MPEG2
