//
// URLResponse.cpp
//

#define DBG_LEVEL 0
#include <Raym/Log.h>
#include <Raym/URLResponse.h>

namespace Raym
{

#define RELEASE(P1)         \
    if ((P1) != NULL)       \
    {                       \
        (P1)->release();    \
        (P1) = NULL;        \
    }

URLResponse::URLResponse()
{
    DebugLog2("URLResponse::URLResponse()\n");

    _URL = NULL;
    _MIMEType = NULL;
    _expectedContentLength = URLResponseUnknownLength;
    _textEncodingName = NULL;
}

URLResponse::~URLResponse()
{
    DebugLog2("URLResponse::~URLResponse()\n");

    RELEASE(_URL);
    RELEASE(_MIMEType);
    _expectedContentLength = URLResponseUnknownLength;
    RELEASE(_textEncodingName);
}

URLResponse *URLResponse::alloc()
{
    DebugLog2("URLResponse::alloc()\n");

    return new URLResponse();
}

URLResponse *URLResponse::initWithURL(URL *URL, String *MIMEType, long long expectedContentLength, String *textEncodingName)
{
    DebugLog2("URLResponse::initWithURL()\n");

    if ((URL == NULL) || (MIMEType == NULL) || ((expectedContentLength < 0) && (expectedContentLength != URLResponseUnknownLength)) || (textEncodingName == NULL))
    {
        DebugLog3("error: parameter check NG.\n");
        return NULL;
    }

    _URL = URL;
    _URL->retain();
    _MIMEType = MIMEType;
    _MIMEType->retain();
    _expectedContentLength = expectedContentLength;
    _textEncodingName = textEncodingName;
    _textEncodingName->retain();

    DebugLog3("URLResponse::initWithURL() %016x %016x %016x\n", _URL, _MIMEType, _textEncodingName);

    return this;
}

String *URLResponse::MIMEType()
{
    DebugLog2("URLResponse::MIMEType()\n");

    return _MIMEType;
}

String *URLResponse::suggestedFilename()
{
    DebugLog2("URLResponse::suggestedFilename()\n");

    return NULL;
}

String *URLResponse::textEncodingName()
{
    DebugLog2("URLResponse::textEncodingName()\n");

    return _textEncodingName;
}

URL *URLResponse::url()
{
    DebugLog2("URLResponse::url()\n");

    return _URL;
}

long long URLResponse::expectedContentLength()
{
    DebugLog2("URLResponse::expectedContentLength()\n");

    return _expectedContentLength;
}

const char *URLResponse::className()
{
    return "URLResponse";
}

} // Raym
