//
// Number.h
//

#pragma once

#include <vector>

#include <Raym/Object.h>
#include <Raym/String.h>

namespace Raym
{

class Number : public Object
{
private:
    enum {
        TYPE_Unkonown,
        TYPE_Bool,
        TYPE_Char,
        TYPE_Double,
        TYPE_Float,
        TYPE_Int,
        TYPE_Integer,
        TYPE_Long,
        TYPE_LongLong,
        TYPE_Short,
        TYPE_UnsignedChar,
        TYPE_UnsignedInt,
        TYPE_UnsignedInteger,
        TYPE_UnsignedLong,
        TYPE_UnsignedLongLong,
        TYPE_UnsignedShort
    }   _type;
    union {
        bool                _boolValue;
        char                _charValue;
        double              _doubleValue;
        float               _floatValue;
        int                 _intValue;
        Integer             _integerValue;
        long                _longValue;
        long long           _longlongValue;
        short               _shortValue;
        unsigned char       _unsignedCharValue;
        unsigned int        _unsignedIntValue;
        UInteger            _unsignedIntegerValue;
        unsigned long       _unsignedLongValue;
        unsigned long long  _unsignedLongLongValue;
        unsigned short      _unsignedShortValue;
    }   _value;

protected:
    Number();
    ~Number();

public:
    static Number *alloc();
    Number *initWithBool(bool value);
    Number *initWithChar(char value);
    Number *initWithDouble(double value);
    Number *initWithFloat(float value);
    Number *initWithInt(int value);
    Number *initWithInteger(Integer value);
    Number *initWithLong(long value);
    Number *initWithLongLong(long long value);
    Number *initWithShort(short value);
    Number *initWithUnsignedChar(unsigned char value);
    Number *initWithUnsignedInt(unsigned int value);
    Number *initWithUnsignedInteger(UInteger value);
    Number *initWithUnsignedLong(unsigned long value);
    Number *initWithUnsignedLongLong(unsigned long long value);
    Number *initWithUnsignedShort(unsigned short value);
    Number *retain();
    Number *autorelease();

    bool boolValue();
    int intValue();
    uint unsignedIntValue();

    String *description();

    virtual const char *className();
};

} // Raym

