//	Copyright (c) 2008 itok ( http://itok.jp/ , http://110k.net/ )
//	All rights reserved.
//
//	Redistribution and use in source and binary forms, with or without modification, 
//	are permitted provided that the following conditions are met:
//
//	- Redistributions of source code must retain the above copyright notice, 
//	  this list of conditions and the following disclaimer.
//	- Redistributions in binary form must reproduce the above copyright notice, 
//	  this list of conditions and the following disclaimer in the documentation 
//	  and/or other materials provided with the distribution.
//	- Neither the name of itok nor the names of its contributors may be used to endorse 
//	  or promote products derived from this software without specific prior written permission.
//
//	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS 
//	AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, 
//	INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY 
//	AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
//	IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
//	INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
//	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
//	LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
//	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
//	STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
//	ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
//	EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#import "MixiService.h"
#import "Mixi.h"
#import "PUCommon.h"

@interface MixiService (Private)

-(void) getAlbum;
-(void) clearAlbum;

@end


@implementation MixiService

-(id) init
{
	if (self = [super init]) {
		m_albumDic = [[NSMutableDictionary alloc] init];

		[self setValue:[NSNumber numberWithBool:YES] forKeyPath:@"spec.account"];
		[self setValue:[NSNumber numberWithBool:YES] forKeyPath:@"spec.password"];
		[self setValue:[NSNumber numberWithBool:YES] forKeyPath:@"spec.album"];
		[self setValue:[NSNumber numberWithBool:NO] forKeyPath:@"spec.title"];
		[self setValue:[NSNumber numberWithBool:NO] forKeyPath:@"spec.keyword"];
		[self setValue:[NSNumber numberWithBool:NO] forKeyPath:@"spec.comment"];
		
		[self setValue:MIXI_URL forKeyPath:@"param.keychainURL"];
		[self setValue:@"mixi" forKeyPath:@"param.saveKey"];

		[self setValue:
		 [NSArray arrayWithObjects:
		  [NSNumber numberWithInt:kPUImageFormat_Jpeg], 
		  nil] 
			forKeyPath:@"spec.formats"];
	}
	return self;
}

-(void) dealloc
{
	[m_albumDic release];
	
	[super dealloc];
}

#pragma mark ___ PUService protocol ___

-(NSString*) title
{
	return LOCALIZED(@"mixi");
}

-(PURequest*) createRequest:(PUPhoto*)photo
{
	MXAlbum* album = [m_albumDic objectForKey:[self valueForKeyPath:@"param.albumTitle"]];
	return [[[Mixi_Photo alloc] initWithAlbum:album] autorelease];
}

-(NSDictionary*) convertAttributes
{
	return nil;
}

-(NSURL*) URLForLastUpload:(NSArray*)responses
{
	NSString* path;
	MXPhoto* photo = [responses objectAtIndex:0];
	if (![photo isKindOfClass:[MXPhoto class]]) {
		return nil;
	}
#if 1
	path = [photo valueForKey:@"url"];
#else
	if ([responses count] == 0) {
		path = [album valueForKey:@"href"];
	} else {
		if ([responses count] == 1) {
			/* 写真ページそのもの */
			path = [photo valueForKey:@"url"];
		} else {
			/* アルバムページ */
			path = [album valueForKey:@"href"];
		}
	}
#endif
	if (path) {
		return [NSURL URLWithString:path];
	}
	return nil;
}

-(void) login
{
	NSString* account = [self valueForKeyPath:@"param.account"];
	NSString* password = [self valueForKeyPath:@"param.password"];
	if (IS_NULL_STR(account) || IS_NULL_STR(password)) {
		[self clearAlbum];
		return;
	}
	[MixiRequest setUsername:account];
	[MixiRequest setPassword:password];
	[self getAlbum];
}

#pragma mark ___ delegate ___

-(void) request:(PURequest*)request didCompletedWithResult:(int)code
{
	//	NSLog(@"didCompletedWithResult %d", code);
	if ([request isKindOfClass:[Mixi_Service class]]) {
		NSError* err = nil;
		NSArray* albums = [request responseData:&err];
		if (!albums || err) {
			if (err) {
				NSRunAlertPanel([NSString stringWithFormat:LOCALIZED(@"Error Occurred : error code %d"), [err code]], [err localizedDescription], LOCALIZED(@"OK"), @"", @"");
			} else {
				NSRunAlertPanel(LOCALIZED(@"Unknown Error Occurred"), @"", LOCALIZED(@"OK"), @"", @"");				
			}
			[request release];
			return;
		}
		
		NSEnumerator* enume = [albums objectEnumerator];
		MXAlbum* album;
		[m_albumDic removeAllObjects];
		while (album = [enume nextObject]) {
			[m_albumDic setObject:album forKey:[album valueForKey:@"title"]];
		}
		[self setValue:[m_albumDic allKeys] forKeyPath:@"albums"];
		if ([_albums count] > 0) {
			[self setValue:[_albums objectAtIndex:0] forKeyPath:@"param.albumTitle"];
		}
	}
	
	[request release];
}


@end

@implementation MixiService (Private)

-(void) getAlbum
{
	Mixi_Service* req = [[Mixi_Service alloc] init];
	[req setDelegate:self];
	[req start];
}	

-(void) clearAlbum
{
	[m_albumDic removeAllObjects];
	[self setValue:[NSArray array] forKeyPath:@"albums"];
}

@end